% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SolveItem.R
\name{SolveItem}
\alias{SolveItem}
\title{SolveItem}
\description{
specify whether the optimization problem is a satisfaction,
minimization or maximization problem and/or expression to maximize/minnimize
and/or annotation
}
\section{Super class}{
\code{\link[rminizinc:Item]{rminizinc::Item}} -> \code{SolveItem}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{.e}}{the expression to maximize or minimize}

\item{\code{.st}}{the solve type}

\item{\code{.ann}}{annotation of the solve type}

\item{\code{.delete_flag}}{used to delete items}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{.e}}{the expression to maximize or minimize}

\item{\code{.st}}{the solve type}

\item{\code{.ann}}{annotation of the solve type}

\item{\code{.delete_flag}}{used to delete items}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{SolveItem$new()}}
\item \href{#method-getExp}{\code{SolveItem$getExp()}}
\item \href{#method-getAnn}{\code{SolveItem$getAnn()}}
\item \href{#method-setExp}{\code{SolveItem$setExp()}}
\item \href{#method-setAnn}{\code{SolveItem$setAnn()}}
\item \href{#method-getSt}{\code{SolveItem$getSt()}}
\item \href{#method-setSt}{\code{SolveItem$setSt()}}
\item \href{#method-c_str}{\code{SolveItem$c_str()}}
\item \href{#method-getDeleteFlag}{\code{SolveItem$getDeleteFlag()}}
\item \href{#method-delete}{\code{SolveItem$delete()}}
\item \href{#method-clone}{\code{SolveItem$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
create an instance of specify_problem class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SolveItem$new(solve_type = NULL, e = NULL, ann = NULL, mzn_str = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{solve_type}}{satisfaction, minimization or maximization}

\item{\code{e}}{expression to minimize or maximize}

\item{\code{ann}}{annotation}

\item{\code{mzn_str}}{string representation of Solve Item}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getExp"></a>}}
\if{latex}{\out{\hypertarget{method-getExp}{}}}
\subsection{Method \code{getExp()}}{
get the expression (or NULL)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SolveItem$getExp()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getAnn"></a>}}
\if{latex}{\out{\hypertarget{method-getAnn}{}}}
\subsection{Method \code{getAnn()}}{
get the annotation (or NULL)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SolveItem$getAnn()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setExp"></a>}}
\if{latex}{\out{\hypertarget{method-setExp}{}}}
\subsection{Method \code{setExp()}}{
set the expression
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SolveItem$setExp(e)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{e}}{expression}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setAnn"></a>}}
\if{latex}{\out{\hypertarget{method-setAnn}{}}}
\subsection{Method \code{setAnn()}}{
set the annotation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SolveItem$setAnn(ann)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ann}}{annotation or Null}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getSt"></a>}}
\if{latex}{\out{\hypertarget{method-getSt}{}}}
\subsection{Method \code{getSt()}}{
get the solve type/objective
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SolveItem$getSt()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setSt"></a>}}
\if{latex}{\out{\hypertarget{method-setSt}{}}}
\subsection{Method \code{setSt()}}{
set the solve type/objective
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SolveItem$setSt(objective)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{objective}}{solve type}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-c_str"></a>}}
\if{latex}{\out{\hypertarget{method-c_str}{}}}
\subsection{Method \code{c_str()}}{
to string method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SolveItem$c_str()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getDeleteFlag"></a>}}
\if{latex}{\out{\hypertarget{method-getDeleteFlag}{}}}
\subsection{Method \code{getDeleteFlag()}}{
delete flag for internal use
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SolveItem$getDeleteFlag()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-delete"></a>}}
\if{latex}{\out{\hypertarget{method-delete}{}}}
\subsection{Method \code{delete()}}{
delete the variable item
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SolveItem$delete()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SolveItem$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
