% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmw_clip.R
\name{rmw_clip}
\alias{rmw_clip}
\title{Function to "clip" the edges of a normalised time series after being 
produced with \code{\link{rmw_normalise}}.}
\usage{
rmw_clip(df, seconds = 31536000/2)
}
\arguments{
\item{df}{Data frame from \code{\link{rmw_normalise}}.}

\item{seconds}{Number of seconds to clip from start and end of time-series. 
The default is half a year.}
}
\value{
Data frame.
}
\description{
\code{rmw_clip} helps if the random forest model behaves strangely at the 
beginning and end of the time series during prediction.
}
\examples{

# Clip the edges of a normalised time series, default is half a year
data_normalised_clipped <- rmw_clip(data_london_normalised)

}
\seealso{
\code{\link{rmw_normalise}}, \code{\link{rmw_plot_normalised}}
}
\author{
Stuart K. Grange
}
