% Generated by roxygen2 (4.0.1): do not edit by hand
\name{getOccurrences}
\alias{getOccurrences}
\title{Get occurrences for a given species}
\usage{
getOccurrences(tvks = NULL, datasets = NULL, startYear = NULL,
  endYear = NULL, VC = NULL, group = NULL, gridRef = NULL,
  latLong = TRUE, acceptTandC = FALSE, silent = FALSE,
  attributes = FALSE)
}
\arguments{
\item{tvks}{a list of TVKs which are strings of 16 alphanumeric characters.
You can look these up using \code{getTVKQuery}}

\item{datasets}{a list of dataset keys which are strings of 8 alphanumeric
characters. Look up datasets here: \url{https://data.nbn.org.uk/Datasets}}

\item{startYear}{a 4 digit integer year}

\item{endYear}{a 4 digit integer year}

\item{VC}{a string giving a vice-county name (see \code{\link{listVCs}})}

\item{group}{a string giving the name of a group (see \code{\link{listGroups}}).
Using group will retireve data for all TVKs in this group. for example using group 'reptile'
will search using over 150 TVKs including TVKs for higher taxonomic groups such families
within reptiles. Therefore it may be preferrable to search using a list TVKs aquired
using getTVKQuery}

\item{gridRef}{a string giving a gridreference in which to search for occurrences}

\item{latLong}{logical, if TRUE latitude and longitude are returned as additional columns.
The conversion to latitude and longitude is currently accurate to about about ~20 meters,
greater than the vast majoring of records' precision.}

\item{acceptTandC}{if set to \code{TRUE} you accept the NBN gateway terms and
conditions and privacy policy. These can be found at \url{https://data.nbn.org.uk/Terms}.
Accepting the terms and conditions supresses the corresponding warning message.}

\item{silent}{If \code{TRUE} batch request information is supressed}

\item{attributes}{If \code{FALSE} then attribute data is not returned, this may
improve the speed of large requests.}
}
\value{
a data.frame of occurence records. Details of the data providers that
contributed to the data returned is given as a 'providers' attribute
}
\description{
Gets occurrence data from the NBN to which you have access. To get access to data
you must first register at \url{https://data.nbn.org.uk/User/Register}. You will
need your username and password when running this function for the first time.\cr
You can specify the data to retrieve by dataset, species, time, location and/or
group.
}
\examples{
\dontrun{
 dt1 <- getOccurrences(tvks="NBNSYS0000002987", datasets="GA000373",
                       startYear="1990", endYear="1991")

 dt2 <- getOccurrences(tvks=c("NBNSYS0000002987","NHMSYS0001688296","NHMSYS0000080210"),
                       startYear="1990", endYear="1991")

 dt3 <- getOccurrences(group="quillwort", startYear="1990", endYear="2010",
                       VC="Shetland (Zetland)")

 # Get the data providers information
 dp <- attr(dt1,'providers')

}
}
\author{
Stuart Ball, JNCC \email{stuart.ball@jncc.gov.uk} and Tom August, CEH \email{tomaug@ceh.ac.uk}
}
\seealso{
\code{\link{getFeature}}, \code{\link{getTVKQuery}}, \code{\link{listVCs}},
\code{\link{listDatasets}}, \code{\link{listGroups}}
}

