/* ***************************************************************************** */
/* Copyright:      Francois Panneton and Pierre L'Ecuyer, University of Montreal */
/*                 Makoto Matsumoto, Hiroshima University                        */
/* Notice:         This code can be used freely for personal, academic,          */
/*                 or non-commercial purposes. For commercial purposes,          */
/*                 please contact P. L'Ecuyer at: lecuyer@iro.UMontreal.ca       */
/* ***************************************************************************** */

// This file is a copy of the file
//   http://www.iro.umontreal.ca/~panneton/well/WELL1024a.c
// with minor formatting modifications and extended with the function GetWELLRNG1024a()
// for interface to R package randtoolbox/rngWELL by Ch. Dutang and P. Savicky.

#define W 32
#define R 32

#define M1 3
#define M2 24
#define M3 10

#include "WELLmatrices.h"

#define V0            STATE[state_i                   ]
#define VM1           STATE[(state_i+M1) & 0x0000001fU]
#define VM2           STATE[(state_i+M2) & 0x0000001fU]
#define VM3           STATE[(state_i+M3) & 0x0000001fU]
#define Vrm1          STATE[(state_i+31) & 0x0000001fU]
#define newV0         STATE[(state_i+31) & 0x0000001fU]
#define newV1         STATE[state_i                   ]

#define FACT 2.32830643653869628906e-10

static unsigned int state_i = 0;
static unsigned int STATE[R];
static unsigned int z0, z1, z2;

void InitWELLRNG1024a (unsigned int *init){
  int j;
  state_i = 0;
  for (j = 0; j < R; j++)
    STATE[j] = init[j];
}

void GetWELLRNG1024a (unsigned int *state){
  int j, k;
  j = 0;
  for (k = state_i; k < R; k++)
    state[j++] = STATE[k];
  for (k = 0; k < state_i; k++)
    state[j++] = STATE[k];
}

double WELLRNG1024a (void){
  z0    = Vrm1;
  z1    = MAT1(V0) ^ MAT0POS(8,VM1);
  z2    = MAT0NEG(-19,VM2) ^ MAT0NEG(-14,VM3);
  newV1 = z1 ^ z2; 
  newV0 = MAT0NEG(-11,z0) ^ MAT0NEG(-7,z1) ^ MAT0NEG(-13,z2) ;
  state_i = (state_i + 31) & 0x0000001fU;

  return ((double) STATE[state_i]  * FACT);
}

