% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.UME_function.R
\name{run_ume}
\alias{run_ume}
\title{Perform the unrelated mean effects model}
\usage{
run_ume(full, n_iter, n_burnin, n_chains, n_thin)
}
\arguments{
\item{full}{An object of S3 class \code{\link{run_model}}. See 'Value' in
\code{\link{run_model}}.}

\item{n_iter}{Positive integer specifying the number of Markov chains for the
MCMC sampling; an argument of the \code{\link[R2jags]{jags}} function of
the R-package \href{https://CRAN.R-project.org/package=R2jags}{R2jags}.
The default argument is 10000.}

\item{n_burnin}{Positive integer specifying the number of iterations to
discard at the beginning of the MCMC sampling; an argument of the
\code{\link[R2jags]{jags}} function of the R-package
\href{https://CRAN.R-project.org/package=R2jags}{R2jags}.
The default argument is 1000.}

\item{n_chains}{Positive integer specifying the number of chains for the MCMC
sampling; an argument of the \code{\link[R2jags]{jags}} function of the
R-package \href{https://CRAN.R-project.org/package=R2jags}{R2jags}.
The default argument is 2.}

\item{n_thin}{Positive integer specifying the thinning rate for the MCMC
sampling; an argument of the \code{\link[R2jags]{jags}} function of the
R-package \href{https://CRAN.R-project.org/package=R2jags}{R2jags}.
The default argument is 1.}
}
\value{
An R2jags output on the summaries of the posterior distribution, and
  the Gelman-Rubin convergence diagnostic of the following monitored
  parameters:
  \tabular{ll}{
   \code{EM} \tab The summary effect estimate (according to the argument
   \code{measure} defined in \code{\link{run_model}}) for each pairwise
   comparison observed in the network.\cr
   \tab \cr
   \code{dev_o} \tab The deviance contribution of each trial-arm based on the
   observed outcome.\cr
   \tab \cr
   \code{hat_par} \tab The fitted outcome at each trial-arm.\cr
   \tab \cr
   \code{tau} \tab The between-trial standard deviation (assumed common
   across the observed pairwise comparisons) for the whole network, when a
   random-effects model has been specified.\cr
   \tab \cr
   \code{m_tau} \tab The between-trial standard deviation (assumed common
   across the observed pairwise comparisons) for the subset of multi-arm
   trials, when a random-effects model has been specified.\cr
  }

  The output also includes the following elements:
  \tabular{ll}{
   \code{leverage_o} \tab The leverage for the observed outcome at each
   trial-arm.\cr
   \tab \cr
   \code{sign_dev_o} \tab The sign of the difference between observed and
   fitted outcome at each trial-arm.\cr
   \tab \cr
   \code{model_assessment} \tab A data-frame on the measures of model
   assessment: deviance information criterion, number of effective
   parameters, and total residual deviance.\cr
   \tab \cr
   \code{jagsfit} \tab An object of S3 class \code{\link[R2jags]{jags}} with
   the posterior results on all monitored parameters to be used in the
   \code{\link{mcmc_diagnostics}} function.\cr
  }
  Furthermore, \code{run_ume} returns a character vector with the pairwise
  comparisons observed in the network, \code{obs_comp}, and a character
  vector with comparisons between the non-baseline interventions observed in
  multi-arm trials only, \code{frail_comp}. Both vectors are used in
  \code{\link{ume_plot}} function.
}
\description{
Performs the unrelated mean effects model of Dias et al.,
  (2013a) extended to address aggregate binary and continuous missing
  participant outcome data via the pattern-mixture model (Spineli, 2019;
  Spineli et al., 2021). This model offers a global evaluation of the
  plausibility of the consistency assumption in the network
  (Dias et al. (2013b)).
}
\details{
\code{run_ume} inherits the arguments \code{data},
  \code{measure}, \code{model}, \code{assumption}, \code{heter_prior},
  \code{mean_misspar}, and \code{var_misspar} from \code{\link{run_model}}.
  This prevents specifying a different Bayesian model from that considered in
  \code{\link{run_model}}.Therefore, the user needs first to apply
  \code{\link{run_model}}, and then usen\code{run_ume} (see 'Examples').

  Initially, \code{run_ume} calls the \code{\link{improved_ume}} function to
  identify the \emph{frail comparisons}, that is, comparisons between
  non-baseline interventions in multi-arm trials not investigated in any
  two-arm trial of the network (Spineli, 2021). The 'original' model of
  Dias et al., (2013a) omits the frail comparisons from the estimation
  process. Consequently, the number of estimated summary effects is less
  than those obtained by performing separate pairwise meta-analyses
  (see \code{\link{run_series_meta}}).

  \code{run_ume} calls the \code{\link{prepare_ume}} function which contains
  the WinBUGS code as written by Dias et al., (2013a) for binomial and normal
  likelihood to analyse binary and continuous outcome data, respectively.
  \code{\link{prepare_ume}} has been extended to incorporate the
  pattern-mixture model with informative missingness parameters for binary
  and continuous outcome data (see 'Details' in \code{\link{run_model}}).
  \code{\link{prepare_ume}} has been also refined to account for the
  multi-arm trials by assigning conditional univariate normal distributions
  on the basic parameters of these trials, that is, effect parameters between
  non-baseline arms and the baseline arm (Dias et al., 2013b; Spineli, 2021).

  \code{run_ume} runs Bayesian unrelated mean effects model in \code{JAGS}.
  The progress of the simulation appears on the R console.

  The output of \code{run_ume} is not end-user-ready. The
  \code{\link{ume_plot}} function uses the output of \code{run_ume} as an S3
  object and processes it further to provide an end-user-ready output.

  \code{run_ume} can be used only for a network of interventions. In the case
  of two interventions, the execution of the function will be stopped and an
  error message will be printed on the R console.
}
\examples{
data("nma.liu2013")

# Read results from 'run_model' (using the default arguments)
res <- readRDS(system.file('extdata/res_liu.rds', package = 'rnmamod'))

\donttest{
# Run random-effects unrelated mean effects model
# Note: Ideally, set 'n_iter' to 10000 and 'n_burnin' to 1000
run_ume(full = res,
        n_chains = 3,
        n_iter = 1000,
        n_burnin = 100,
        n_thin = 1)
}

}
\references{
Spineli LM. A novel framework to evaluate the consistency assumption globally
in a network of interventions. \emph{submitted} 2021.

Spineli LM, Kalyvas C, Papadimitropoulou K. Continuous(ly) missing outcome
data in network meta-analysis: a one-stage pattern-mixture model approach.
\emph{Stat Methods Med Res} 2021. \doi{10.1177/0962280220983544}

Spineli LM. An empirical comparison of Bayesian modelling strategies for
missing binary outcome data in network meta-analysis.
\emph{BMC Med Res Methodol} 2019;\bold{19}(1):86.
\doi{10.1186/s12874-019-0731-y}

Dias S, Welton NJ, Sutton AJ, Caldwell DM, Lu G, Ades AE. Evidence synthesis
for decision making 4: inconsistency in networks of evidence based on
randomized controlled trials.
\emph{Med Decis Making} 2013a;\bold{33}(5):641--56.
\doi{10.1177/0272989X12455847}

Dias S, Sutton AJ, Ades AE, Welton NJ. Evidence synthesis for decision
making 2: a generalized linear modeling framework for pairwise and network
meta-analysis of randomized controlled trials.
\emph{Med Decis Making} 2013b;\bold{33}(5):607--617.
\doi{10.1177/0272989X12458724}

Gelman A, Rubin DB. Inference from iterative simulation using multiple
sequences. \emph{Stat Sci} 1992;\bold{7}:457--472.
}
\seealso{
\code{\link[R2jags]{jags}}, \code{\link{prepare_ume}},
  \code{\link{run_model}}, \code{\link{run_series_meta}},
  \code{\link{ume_plot}}
}
\author{
{Loukia M. Spineli}
}
