#' ECG trace of healthy subjects
#'
#' A dataset containing the 8-Lead ECG traces of 50 healthy subjects. They can be used to compare the
#' signals of pathological subjects stored in \code{mfD_LBBB} and \code{mfD_RBBB} objects.
#'
#' The 8 leads are, in order, V1, V2, V3, V4, V5, D1 and D2. The signals have been registered and
#' smoothed over an evenly spaced grid of 1024 time points at 1kHz.
#'
#' @format A \code{\link{mfData}} object.
#'
#'
"mfD_healthy"

#' ECG trace of subjects suffering from Left-Bundle-Branch-Block (LBBB)
#'
#' A dataset containing the 8-Lead ECG traces of 50 subjects suffering from
#' Left-Bundle-Branch-Block (LBBB), a cardiac pathology affecting the conduction process and resulting
#' in some peculiar distortions of the ECG.
#'
#' The 8 leads are, in order, V1, V2, V3, V4, V5, D1 and D2. The signals have been registered and
#' smoothed over an evenly spaced grid of 1024 time points at 1kHz.
#'
#' @format A \code{\link{mfData}} object.
#'
"mfD_LBBB"
