% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataSets.R
\docType{data}
\name{employment2}
\alias{employment2}
\title{Employment in different countries by Sex, Age, Contract, Value}
\format{
A data.frame with 504 rows and 5 columns.
}
\source{
https://stats.oecd.org
}
\usage{
data(employment2)
}
\description{
Estimated number of employees in 42 countries in 2015, 
distributed according to gender (Women/Men), 
age (15-24, 25-54, 55+) and type of contract (Full- and part-time).
}
\details{
For each country in the sample, an estimated number of
employees in the year 2015 was available, divided according to gender and age of
employees and the type of the contract. 
The data form a sample of 42 cubes with two rows (gender), two columns (type)                                                                                                                                          of contract) and three slices (age), which allow for a deeper analysis of the overall
employment structure, not just from the perspective of each factor separately, but
also from the perspective of the relations/interactions between them. 
Thorough analysis of the sample is described in Facevicova (2019).

\itemize{
 \item{\code{Country}}{Country}
 \item{\code{Sex}}{gender, males (M) and females (F)}
 \item{\code{Age}}{age class, young (category 15 - 24), middle-aged (25 - 54) and older
(55+) employees}
 \item{\code{Contract}}{factor, defining the type of contract, full-time (FT) and part-time (PT) contracts}
 \item{\code{Value}}{Number of employees in the given category (in thousands)}
}
}
\examples{
data(employment2)
head(employment2)
}
\references{
Facevicova, K., Filzmoser, P. and K. Hron (2019) 
Compositional Cubes: Three-factorial Compositional Data. Under review.
}
\author{
Kamila Facevicova
}
\keyword{data}
