% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ternaryDiagPoints.R
\name{ternaryDiagPoints}
\alias{ternaryDiagPoints}
\alias{ternaryDiagLines}
\title{Add points or lines to a given ternary diagram.}
\usage{
ternaryDiagPoints(x, ...)
}
\arguments{
\item{x}{Three-dimensional composition given as an object of class
\dQuote{matrix} or \dQuote{data.frame}.}

\item{\dots}{Additional graphical parameters passed through.}
}
\value{
no values are returned.
}
\description{
Low-level plot function to add points or lines to a ternary high-level plot.
}
\examples{

data(coffee)
x <- coffee[,2:4]
ternaryDiag(x, grid=FALSE)
ternaryDiagPoints(x+1, col="red", pch=2)

}
\references{
C. Reimann, P. Filzmoser, R.G. Garrett, and R. Dutter:
Statistical Data Analysis Explained. Applied Environmental Statistics with
R. John Wiley and Sons, Chichester, 2008.
}
\seealso{
\code{\link{ternaryDiag}}
}
\author{
Matthias Templ
}
\keyword{aplot}
