% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataSets.R
\docType{data}
\name{arcticLake}
\alias{arcticLake}
\title{arctic lake sediment data}
\format{
A data frame with 39 rows and 3 variables
}
\usage{
data(arcticLake)
}
\description{
Sand, silt, clay compositions of 39 sediment samples at different water depths in an Arctic lake.
This data set can be found on page 359 of the Aitchison book (see reference).
}
\details{
\itemize{
 \item{\code{sand }}{numeric vector of percentages of sand}
 \item{\code{silt }}{numeric vector of percentages of silt}
 \item{\code{clay }}{numeric vector of percentages of clay}
}

The rows sum up to 100, except for rounding errors.
}
\examples{

data(arcticLake)
str(arcticLake)
summary(arcticLake)
rowSums(arcticLake)
ternaryDiag(arcticLake)
plot(pivotCoord(arcticLake))
}
\references{
Aitchison, J. (1986). \emph{The Statistical Analysis of Compositional Data}. Monographs on Statistics and Applied Probability. Chapman and Hall Ltd., London (UK). 416p.
}
\author{
Matthias Templ \email{matthias.templ@tuwien.ac.at}
}
\keyword{data}
