% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ROBIN.R
\name{robinCompare}
\alias{robinCompare}
\title{robinCompare}
\usage{
robinCompare(
  graph,
  method1 = c("walktrap", "edgeBetweenness", "fastGreedy", "leadingEigen", "louvain",
    "spinglass", "labelProp", "infomap", "optimal", "other"),
  method2 = c("walktrap", "edgeBetweenness", "fastGreedy", "leadingEigen", "louvain",
    "spinglass", "labelProp", "infomap", "optimal", "other"),
  FUN1 = NULL,
  FUN2 = NULL,
  measure = c("vi", "nmi", "split.join", "adjusted.rand"),
  type = c("independent", "dependent"),
  directed = FALSE,
  weights = NULL,
  steps = 4,
  spins = 25,
  e.weights = NULL,
  v.weights = NULL,
  nb.trials = 10
)
}
\arguments{
\item{graph}{The output of prepGraph.}

\item{method1}{The first clustering method, one of "walktrap", 
"edgeBetweenness", "fastGreedy", "louvain", "spinglass", "leadingEigen",
"labelProp", "infomap","optimal".}

\item{method2}{The second custering method one of "walktrap",
"edgeBetweenness","fastGreedy", "louvain", "spinglass", "leadingEigen",
"labelProp", "infomap","optimal".}

\item{FUN1}{personal designed function when method1 is "others". 
see \code{\link{methodCommunity}}.}

\item{FUN2}{personal designed function when method2 is "others". 
see \code{\link{methodCommunity}}.}

\item{measure}{The stability measure, one of "vi", "nmi", "split.join", 
"adjusted.rand".}

\item{type}{The type of robin costruction, dependent or independent.}

\item{directed}{This argument is settable only for "edgeBetweenness" method.}

\item{weights}{This argument is not settable for "infomap" method.}

\item{steps}{This argument is settable only for "leadingEigen"and"walktrap" 
method.}

\item{spins}{This argument is settable only for "infomap" method.}

\item{e.weights}{This argument is settable only for "infomap" method.}

\item{v.weights}{This argument is settable only for "infomap" method.}

\item{nb.trials}{This argument is settable only for "infomap" method.}
}
\value{
A list object
}
\description{
This function compares the robustness of two community 
detection algorithms.
}
\examples{
my_file <- system.file("example/football.gml", package="robin")
graph <- prepGraph(file=my_file, file.format="gml")
robinCompare(graph=graph, method1="louvain", 
method2="fastGreedy", measure="vi", type="independent")
}
