% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ROBIN.R
\name{robinFDATest}
\alias{robinFDATest}
\title{robinFDATest}
\usage{
robinFDATest(
  graph,
  model1,
  model2,
  measure = c("vi", "nmi", "split.join", "adjusted.rand"),
  legend = c("real data", "null model"),
  verbose = FALSE
)
}
\arguments{
\item{graph}{The output of prepGraph.}

\item{model1}{The Mean output of the robinRobust function (or the Mean1 
output of the robinCompare function).}

\item{model2}{The MeanRandom output of the robinRobust function (or the 
Mean2 output of the robinCompare function).}

\item{measure}{The stability measure "vi", "nmi", "split.join", 
"adjusted.rand".}

\item{legend}{The legend for the graph. The default is c("real data", 
"null model").}

\item{verbose}{flag for verbose output (default as FALSE).}
}
\value{
Two plots: the fitted curves and the adjusted p-values. A vector of the adjusted p-values.
}
\description{
The function implements the Interval Testing Procedure to 
test the difference between two curves.
}
\examples{
my_file <- system.file("example/football.gml", package="robin")
graph <- prepGraph(file=my_file, file.format="gml")
graphRandom <- random(graph=graph)
Proc <- robinRobust(graph=graph, graphRandom=graphRandom, method="louvain",
measure="vi",type="independent")
robinFDATest(graph=graph, model1=Proc$Mean, model2=Proc$MeanRandom, measure="vi")
}
