% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula.R
\name{m}
\alias{m}
\alias{covariates}
\title{Create an object of hypothesized mediators or control variables}
\usage{
m(...)

covariates(...)
}
\arguments{
\item{\dots}{variables are supplied as arguments, as usual separated by a
comma.}
}
\value{
\code{m()} returns an object of class \code{"parallel_mediators"}
and \code{covariates()} returns an object of class \code{"covariates"}.
Typically, these inherit from class \code{"matrix"}.
}
\description{
\code{m()} creates an object of hypothesized mediators, while
\code{covariates()} creates an object of control variables.  Usually,
these are used in a formula specifying a mediation model.
}
\details{
These are essentially wrappers for \code{\link[base]{cbind}()} with a
specific class prepended to the class(es) of the resulting object.
}
\note{
The formula interface is still experimental and may change in future
versions.
}
\examples{
data("BSG2014")

# inside formula
fit_mediation(TeamCommitment ~ m(TaskConflict) + ValueDiversity,
              data = BSG2014)

# outside formula
mediator <- with(BSG2014, m(TaskConflict))
fit_mediation(TeamCommitment ~ mediator + ValueDiversity,
              data = BSG2014)

}
\seealso{
\code{\link{fit_mediation}()}, \code{\link{test_mediation}()}
}
\author{
Andreas Alfons
}
\keyword{utilities}
