% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robomit_functions.R
\name{o_delta_rsq}
\alias{o_delta_rsq}
\title{Deltas* over a range of max R-squares}
\usage{
o_delta_rsq(y, x, con, id = "none", time = "none", beta = 0, type, data)
}
\arguments{
\item{y}{Name of the dependent variable (as string).}

\item{x}{Name of the independent variable of interest (treatment variable; as string).}

\item{con}{Name of the other control variables. Provided as string in the format: "w + z +...".}

\item{id}{Name of the individual id variable (e.g. firm or farm; as string). Only applicable for fixed effect models.}

\item{time}{Name of the time variable (e.g. year or month; as string). Only applicable for fixed effect models.}

\item{beta}{Beta for which delta* should be estimated (default is beta = 0).}

\item{type}{Model type (either \emph{lm} or \emph{plm}; as string).}

\item{data}{Data.}
}
\value{
Returns tibble object. Including deltas* over a range of max R-squares.
}
\description{
Estimates deltas*, i.e. the degree of selection on unobservables relative to observables that would be necessary to explain away the result, following Oster (2019) over a range of max R-squares following Oster (2019).
}
\details{
Estimates deltas*, i.e. the degree of selection on unobservables relative to observables that would be necessary to explain away the result, following Oster (2019) over a range of max R-squares. The range of max R-squares starts from the R-square of the controlled model rounded up to the next 1/100 to 1. The function supports linear cross sectional (see \emph{lm} objects in R) and panel fixed effect (see \emph{plm} objects in R) models.
}
\examples{
# load data, e.g. the in-build mtcars dataset
data("mtcars")
data_oster <- mtcars

# preview of data
head(data_oster)

# load robomit
require(robomit)

# estimate deltas* over a range of max R-squares
o_delta_rsq(y = "mpg",               # define the dependent variable name
                x = "wt",            # define the main independent variable name
                con = "hp + qsec",   # other control variables
                beta = 0,            # define beta. This is usually set to 0
                type = "lm",         # define model type
                data = data_oster)   # define dataset
}
\references{
Oster, E. (2019). Unobservable selection and coefficient stability: Theory and evidence. Journal of Business & Economic Statistics, 37, 187-204.
}
