% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mediantest.R
\name{mediantest}
\alias{mediantest}
\title{Test for the median in the one and two-sample paired tests}
\usage{
mediantest(
  x,
  y = NULL,
  alternative = "two.sided",
  paired = FALSE,
  conf.level = 0.95
)
}
\arguments{
\item{x, y}{two continuous variables.}

\item{alternative}{indicates the alternative hypothesis and must be one of "two.sided", "greater" or "less".}

\item{paired}{a logical value. If \code{paired=TRUE}, the user must provide values for \code{x} and \code{y}
and the paired test is implemented. If \code{paired=FALSE}, only \code{x} must be provided.}

\item{conf.level}{confidence level for the confidence interval of the median.}
}
\value{
Returns the result of the test with its corresponding p-value and the value of median of X or of X-Y. The confidence interval is also displayed
but only when \code{alternative=two.sided}.
}
\description{
In the one sample case, test if the median of the random variable is equal to 0. In the paired two-sample case, test if the median of the
difference between the two random variables is equal to 0. The function also returns the confidence interval for the median of the
random variable in the one-sample case or for the median of the difference between the two random variables in the two-sample case.
}
\details{
The null hypothesis for the one sample median test is: H0 Med(X)=0 where Med represents the median.
The alternative is specified by the \code{alternative} argument: "\code{greater}" means that Med(X)>0, "\code{less}"
means that Med(X)<0 and "\code{two.sided}" means that Med(X) is different from 0. The null hypothesis for the paired median test is: H0 Med(X-Y)=0. Both tests are asymptotically
calibrated in the sense that the rejection probability under the null hypothesis is asymptotically equal to the level of the test. The
test and the confidence interval are constructed based on asymptotic results on the rank statistics for the uniform distribution, as described in the book
\emph{Asymptotic Statistics} from A. W. Van der Vaart, 1998.
}
\note{
The paired median test can be implemented either by providing the variables \code{x} and \code{y} with \code{paired=TRUE} or by just providing
one vector equal to the difference between \code{x} and \code{y} with \code{paired=FALSE}.
}
\examples{
#Simulations
x <- rexp(200)-log(2)
mediantest(x)
x <- rexp(200)-log(2)+0.2
mediantest(x,alternative="greater")

n=100 #sample size
M=1000 #number of replications
res1=res2=rep(NA,M)
testone=function(n){
D=rchisq(n,df=4)-qchisq(df=4, p=0.5)
list(test1=mediantest(D)$p.value,test2=binom.test(sum(D>0),n)$p.value)
} #test2 is the sign test.
for (i in 1:M)
{
result=testone(n)
res1[i]=result$test1
res2[i]=result$test2
}
mean(res1<0.05) #0.048
mean(res2<0.05) # 0.04
}
\seealso{
\code{\link{cortest}}, \code{\link{indeptest}}, \code{\link{vartest}}, \code{\link{wilcoxtest}}.
}
\author{
See \emph{Asymptotic Statistics}.
A. W. Van der Vaart, 1998.
}
\keyword{test}
