% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expand_attributes.R
\name{expand_attributes}
\alias{expand_attributes}
\title{Expand categorical attribute variables to a series of dichotomous variables}
\usage{
expand_attributes(
  data,
  attributes,
  valueLabels = NULL,
  prefix = "",
  glue = "__",
  suffix = "",
  falseValue = 0,
  trueValue = 1,
  valueFirst = TRUE,
  append = TRUE
)
}
\arguments{
\item{data}{The data frame, normally the \verb{$mergedSources} data frame that
exists in the object returned by a call to \code{\link[=parse_sources]{parse_sources()}}.}

\item{attributes}{The name of the attribute(s) to expand.}

\item{valueLabels}{It's possible to use different names for the created
variables than the values of the attributes. This can be set with the
\code{valueLabels} argument. If only one attribute is specified, pass a named
vector for \code{valueLabels}, and if multiple attributes are specified, pass
a named list of named vectors, where the name of each vector corresponds to
an attribute passed in \code{attributes}. The names of the vector elements
must correspond to the values of the attributes (see the example).}

\item{prefix, suffix}{The prefix and suffix to add to the variables names
that are returned.}

\item{glue}{The glue to paste the first part ad the second part of the
composite variable name together.}

\item{falseValue, trueValue}{The values to set for rows that, respectively,
do not match and do match an attribute value.}

\item{valueFirst}{Whether to insert the attribute value first, or the
attribute name, in the composite variable names.}

\item{append}{Whether to append the columns to the supplied data
frame or not.}
}
\value{
A data.frame
}
\description{
Expand categorical attribute variables to a series of dichotomous variables
}
\examples{
### Get path to example source
examplePath <-
  system.file("extdata", package="rock");

### Get a path to one example file
exampleFile <-
  file.path(examplePath, "example-1.rock");

### Parse single example source
parsedExample <- rock::parse_source(exampleFile);

### Create a categorical attribute column
parsedExample$mergedSourceDf$age_group <-
  rep(c("<18", "18-30", "31-60", ">60"), each=13);

### Expand to four logical columns
parsedExample$mergedSourceDf <-
  rock::expand_attributes(
    parsedExample$mergedSourceDf,
    "age_group",
    valueLabels =
      c(
        "<18" = "youngest",
        "18-30" = "youngish",
        "31-60" = "oldish",
        ">60" = "oldest"
       ),
    valueFirst = FALSE
);

### Show result
table(parsedExample$mergedSourceDf$age_group,
      parsedExample$mergedSourceDf$age_group__youngest);
table(parsedExample$mergedSourceDf$age_group,
      parsedExample$mergedSourceDf$age_group__oldish);
}
