% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recode_move.R
\name{recode_move}
\alias{recode_move}
\title{Move one or more codes to a different parent}
\usage{
recode_move(
  input,
  codes,
  newAncestry,
  filter = TRUE,
  output = NULL,
  decisionLabel = NULL,
  justification = NULL,
  justificationFile = NULL,
  preventOverwriting = rock::opts$get("preventOverwriting"),
  encoding = rock::opts$get("encoding"),
  silent = rock::opts$get("silent")
)
}
\arguments{
\item{input}{One of 1) a character string specifying the path to a file
with a source; 2) an object with a loaded source as produced by a call
to \code{\link[=load_source]{load_source()}}; 3) a character string specifying the path to a directory
containing one or more sources; 4) or an object with a list of loaded
sources as produced by a call to \code{\link[=load_sources]{load_sources()}}.}

\item{codes}{A character vector with codes to move.}

\item{newAncestry}{The new parent code, optionally including the partial
or full ancestry (i.e. the path of parent codes all the way up to the root).}

\item{filter}{Optionally, a filter to apply to specify a subset of the
source(s) to process (see \code{\link[=get_source_filter]{get_source_filter()}}).}

\item{output}{If specified, the recoded source(s) will be written here.}

\item{decisionLabel}{A description of the (recoding) decision that was taken.}

\item{justification}{The justification for this action.}

\item{justificationFile}{If specified, the justification is appended to
this file. If not, it is saved to the \code{justifier::workspace()}. This can
then be saved or displayed at the end of the R Markdown file or R script
using \code{justifier::save_workspace()}.}

\item{preventOverwriting}{Whether to prevent overwriting existing files
when writing the files to \code{output}.}

\item{encoding}{The encoding to use.}

\item{silent}{Whether to be chatty or quiet.}
}
\value{
Invisibly, the changed source(s) or source(s) object.
}
\description{
These functions move a code to a different parent (and therefore,
ancestry) in one or more sources.
}
\examples{
### Get path to example source
examplePath <-
  system.file("extdata", package="rock");

### Get a path to one example file
exampleFile <-
  file.path(examplePath, "example-1.rock");

### Load example source
loadedExample <- rock::load_source(exampleFile);

### Move two codes to a new parent, showing progress
recoded_source <-
  rock::recode_move(
    loadedExample,
    codes=c("childCode2", "childCode1"),
    newAncestry = "parentCode2",
    silent=FALSE
  );
}
