% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/star_database_export.R
\name{as_dm_class}
\alias{as_dm_class}
\alias{as_dm_class.star_database}
\title{Generate a \code{dm} class with fact and dimension tables}
\usage{
as_dm_class(db, pk_facts)

\method{as_dm_class}{star_database}(db, pk_facts = TRUE)
}
\arguments{
\item{db}{A \code{star_database} object.}

\item{pk_facts}{A boolean, include primary key in fact tables.}
}
\value{
A \code{dm} object.
}
\description{
To port databases to other work environments it is useful to be able to
export them as a \code{dm} class, as this function does, in this way it can be
saved directly in a DBMS.
}
\examples{

db1 <- star_database(mrs_cause_schema, ft_num) |>
  snake_case()
dm1 <- db1 |>
  as_dm_class()

db2 <- star_database(mrs_age_schema, ft_age) |>
  snake_case()

ct <- constellation("MRS", db1, db2)
dm <- ct |>
  as_dm_class()

}
\seealso{
\code{\link{star_database}}

Other star database exportation functions: 
\code{\link{as_single_tibble_list}()},
\code{\link{as_tibble_list}()}
}
\concept{star database exportation functions}
