% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flat_table.R, R/generic.R, R/star_database.R
\name{get_attribute_names.flat_table}
\alias{get_attribute_names.flat_table}
\alias{get_attribute_names}
\alias{get_attribute_names.star_database}
\title{Get the names of the attributes}
\usage{
\method{get_attribute_names}{flat_table}(db, name = NULL, ordered = FALSE, as_definition = FALSE)

get_attribute_names(db, name, ordered, as_definition)

\method{get_attribute_names}{star_database}(db, name, ordered = FALSE, as_definition = FALSE)
}
\arguments{
\item{db}{A \code{flat_table} or \code{star_database} object.}

\item{name}{A string, dimension name.}

\item{ordered}{A boolean, sort names alphabetically.}

\item{as_definition}{A boolean, get the names as a vector definition in R.}
}
\value{
A vector of strings or a string, attribute names.
}
\description{
Obtain the names of the attributes in a flat table or a dimension in a star
database.
}
\details{
If indicated, names can be obtained in alphabetical order or as a vector
definition in R
}
\examples{

names <- star_database(mrs_cause_schema, ft_num) |>
  get_attribute_names(name = "where")

names <- flat_table('iris', iris) |>
  get_attribute_names()

}
\seealso{
\code{\link{star_database}}, \code{\link{flat_table}}

Other star database and flat table functions: 
\code{\link{get_measure_names.flat_table}()},
\code{\link{get_similar_attribute_values.flat_table}()},
\code{\link{get_similar_attribute_values_individually.flat_table}()},
\code{\link{get_unique_attribute_values.flat_table}()},
\code{\link{replace_attribute_values.flat_table}()},
\code{\link{set_attribute_names.flat_table}()},
\code{\link{set_measure_names.flat_table}()},
\code{\link{snake_case.flat_table}()}
}
\concept{star database and flat table functions}
