% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/star_database.R
\name{group_dimension_instances}
\alias{group_dimension_instances}
\alias{group_dimension_instances.star_database}
\title{Group instances of a dimension}
\usage{
group_dimension_instances(db, name)

\method{group_dimension_instances}{star_database}(db, name)
}
\arguments{
\item{db}{A \code{star_database} object.}

\item{name}{A string, dimension name.}
}
\value{
A \code{star_database} object.
}
\description{
After changes in values in the instances of a dimension, groups the instances
and, if necessary, also the related facts.
}
\examples{

db <- star_database(mrs_cause_schema, ft_num) |>
  group_dimension_instances(name = "where")

}
\seealso{
\code{\link{as_tibble_list}}, \code{\link{as_dm_class}}

Other star database definition functions: 
\code{\link{get_dimension_names}()},
\code{\link{get_fact_names}()},
\code{\link{get_table_names}()},
\code{\link{role_playing_dimension}()},
\code{\link{star_database}()}
}
\concept{star database definition functions}
