% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/star_query.R
\name{select_fact}
\alias{select_fact}
\alias{select_fact.star_query}
\title{Select fact}
\usage{
select_fact(sq, name, measures, agg_functions)

\method{select_fact}{star_query}(sq, name = NULL, measures = NULL, agg_functions = NULL)
}
\arguments{
\item{sq}{A \code{star_query} object.}

\item{name}{A string, name of the fact.}

\item{measures}{A vector of measure names.}

\item{agg_functions}{A vector of aggregation function names, each one for its
corresponding measure. They can be SUM, MAX or MIN.}
}
\value{
A \code{star_query} object.
}
\description{
To define the fact to be consulted, its name is indicated, optionally, a
vector of names of selected measures and another of aggregation functions are
also indicated.
}
\details{
If there is only one fact table, it is the one that is considered if no name
is indicated.

If no measure is given, only the one corresponding to the number of aggregated
rows will be included (it is always included).

If no aggregation function is given, those defined for the measures are considered.
}
\examples{

sq <- mrs_db |>
  star_query()

sq_1 <- sq |>
  select_fact(
    name = "mrs_age",
    measures = "all_deaths",
    agg_functions = "MAX"
  )

sq_2 <- sq |>
  select_fact(name = "mrs_age",
              measures = "all_deaths")

sq_3 <- sq |>
  select_fact(name = "mrs_age")

}
\seealso{
Other query functions: 
\code{\link{filter_dimension}()},
\code{\link{run_query}()},
\code{\link{select_dimension}()},
\code{\link{star_query}()}
}
\concept{query functions}
