% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/drawing.R
\name{plotVF}
\alias{plotVF}
\title{Plot value function}
\usage{
plotVF(solution, criteria = NULL, yAxis = "max", showAlternatives = FALSE,
  titles = TRUE, plotsPerRow = 2)
}
\arguments{
\item{solution}{Solution to plot (e.g. result of
\code{\link{findRepresentativeFunction}}, \code{\link{findSimpleFunction}}
or \code{\link{investigateUtility}}).}

\item{criteria}{Indices of criteria to plot. If NULL all criteria will be plotted.}

\item{yAxis}{Y axis limit (\code{"adjusted"} - maximal value on single plot,
\code{"max"} - maximal value on all criteria,
\code{"unit"} - one).}

\item{showAlternatives}{Whether to mark values of alternatives.}

\item{titles}{Vector of titles for charts or boolean value(s) whether default title should be used.}

\item{plotsPerRow}{Maximal plots per row.}
}
\description{
This function draws value function for selected criteria.
}
\examples{
perf <- matrix(c(5, 2, 1, 7, 0.5, 0.9, 0.4, 0.4), ncol = 2)
problem <- buildProblem(perf, 3, FALSE, c('c', 'g'), c(3, 3))
problem <- addAssignmentsLB(problem, c(1, 2), c(2, 3))

representativeFunction <- findRepresentativeFunction(problem, 0)
plotVF(representativeFunction)
}
\seealso{
\code{\link{findRepresentativeFunction}}
\code{\link{findSimpleFunction}}
\code{\link{investigateUtility}}
\code{\link{plotComprehensiveValue}}
}

