% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/main.R
\name{findRepresentativeFunction}
\alias{findRepresentativeFunction}
\title{Find representative utility function}
\usage{
findRepresentativeFunction(problem, mode, relation = NULL)
}
\arguments{
\item{problem}{Problem to investigate.}

\item{mode}{An integer that represents a method of a computing representative
utility function:
\itemize{
\item \code{0} - iterative mode,
\item \code{1} - compromise mode.
}}

\item{relation}{A matrix of assignment pairwise comparisons (see
\code{\link{compareAssignments}}). If the parameter is \code{NULL}, the relation
will be computed.}
}
\value{
List with named elements:
\itemize{
\item \code{vf} - list of 2-column matrices with marginal value functions (characteristic point in rows),
\item \code{thresholds},
\item \code{assignments},
\item \code{alternativeValues},
\item \code{epsilon}.
}
\code{NULL} is returned if representative function cannot be found.
}
\description{
This function finds a representative utility function for a problem.
}
\examples{
perf <- matrix(c(5, 2, 1, 7, 0.5, 0.9, 0.4, 0.4), ncol = 2)
problem <- buildProblem(perf, 3, FALSE, c('g', 'g'), c(0, 0))
problem <- addAssignmentsLB(problem, c(1, 2), c(2, 3))

representativeFunction <- findRepresentativeFunction(problem, 0)
assignments <- representativeFunction$assignments
}
\seealso{
\code{\link{plotVF}}
\code{\link{plotComprehensiveValue}}
\code{\link{findSimpleFunction}}
}

