% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/drawing.R
\name{plotComprehensiveValue}
\alias{plotComprehensiveValue}
\title{Plot comprehensive values of altarnatives}
\usage{
plotComprehensiveValue(solution, order = "alternatives",
  showThresholds = FALSE, title = FALSE)
}
\arguments{
\item{solution}{Solution to plot (e.g. result of
\code{\link{findRepresentativeFunction}}, \code{\link{findSimpleFunction}}
or \code{\link{investigateUtility}}).}

\item{order}{Order of alternatives (\code{"alternatives"}, \code{"asc"}, \code{"desc"}).}

\item{showThresholds}{Whether to print threholds (dashed lines).}

\item{title}{Title for chart or boolean value whether default title should be used.}
}
\value{
Plot.
}
\description{
This function draws bar chart of comprehensive values of altarnatives.
}
\examples{
perf <- matrix(c(5, 2, 1, 7, 0.5, 0.9, 0.4, 0.4), ncol = 2)
problem <- buildProblem(perf, 3, FALSE, c('c', 'g'), c(3, 3))
problem <- addAssignmentsLB(problem, c(1, 2), c(2, 3))

representativeFunction <- findRepresentativeFunction(problem, 0)
plotComprehensiveValue(representativeFunction)
}
\seealso{
\code{\link{findRepresentativeFunction}}
\code{\link{findSimpleFunction}}
\code{\link{investigateUtility}}
\code{\link{plotVF}}
}

