% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rosm-package.R
\docType{package}
\name{rosm}
\alias{rosm}
\alias{rosm-package}
\title{Plot Raster Map Tiles From Open Street Map and Other Sources}
\description{
This package provides access and plots \href{http://www.openstreetmap.org/}{Open Street Map}
and \href{http://www.bing.com/maps}{Bing Maps} tiles
to create high-resolution basemaps and use hillshade tiles to add texture to other maps.
Uses the '\href{https://cran.r-project.org/package=sp}{sp}' package to plot using base graphics. Plot Open Street Map derivative
tiles using \link{osm.plot}, and plot Bing maps (Aerial, Labeled Aerial, Road) using
\link{bmaps.plot}. 16 OSM and 3 Bing sources are included, with the ability to define
custom tile sources based on OSM tilex, tiley, and zoom. Use \link{osm.raster} to get
tiles in a \code{RasterStack} or write to disk (requires
the '\href{https://cran.r-project.org/package=raster}{raster}' package.)
}
\examples{

\donttest{
 library(prettymapr)

 # basic ploting
 nsbox <- searchbbox("nova scotia")
 osm.plot(nsbox)
 osm.plot(nsbox, type="stamenbw")
 bmaps.plot(nsbox)
 bmaps.plot(nsbox, type="Road")

 # use prettymapr to add scalebar and north arrow
 prettymap(osm.plot(nsbox))
 prettymap(bmaps.plot(nsbox, type="Road"))

 # define custom tile types in several ways

 # using string formats
 ts <- as.tile_source("http://a.basemaps.cartocdn.com/dark_all/${z}/${x}/${y}.png")
 osm.plot(nsbox, type=ts)

 # using string formats and register_tile_source
 register_tile_source(dark = "http://a.basemaps.cartocdn.com/dark_all/${z}/${x}/${y}.png")
 osm.plot(nsbox, type="dark")

 # set default plot type to something other than 'osm'
 set_default_tile_source("stamenbw")
 osm.plot(nsbox)

 }

}
\references{
\href{http://wiki.openstreetmap.org/wiki/Tile_servers}{Open Street Map tile servers},
\href{https://www.microsoft.com/maps/choose-your-bing-maps-API.aspx}{Bing Maps API documentation}
}
\author{
Dewey Dunnington <dewey@fishandwhistle.net>
}
