\name{debianize}
\alias{debianize}
\title{Basic Debian package creation from R source packages}
\usage{
  debianize(pck.source.dir, repo.root,
    build.dir = tempdir(), revision = 1, origin = "other",
    distribution = "unstable", component = "main",
    urgency = "low", changelog = c("new upstream release"),
    deb.description = NULL,
    actions = c("deb", "bin", "src"),
    overwrite = c("changelog", "control", "copyright", "rules"),
    bin.opts = "-rfakeroot -b -uc", arch = "all",
    compat = 7, gpg.key = NULL, keep.build = FALSE,
    replace.dots = FALSE)
}
\arguments{
  \item{pck.source.dir}{Character string, path pointing to
  the root directory of your package sources.}

  \item{repo.root}{Character string, valid path to a
  directory where to build/update a local package
  repository.}

  \item{build.dir}{Character string, valid path to a
  directory where to build the package.}

  \item{revision}{Numeric or a character string, the Debian
  package revision number.}

  \item{origin}{Character string, should be either
  "noncran" or "other-<yourname>", used for the package
  name. This indicates that your package is not an official
  CRAN or BioC package.}

  \item{distribution}{Character string, the Debain (based)
  distribution your package is intended for.}

  \item{component}{Character string, the Debain component
  of the distribution.}

  \item{urgency}{Character string, urgency information for
  this release (refer to [1] if you want to change this).}

  \item{changelog}{Character vector, log entries for the
  \code{./debian/changelog} file if it is going to be
  changed.}

  \item{deb.description}{A named list or data.frame with
  further information, especially for the
  \code{./debian/control} file. This is similar to the
  \code{pck.description} parameter of
  \code{\link[roxyPackage:roxy.package]{roxy.package}},
  only with different variables.  Note that if certain key
  values are missing, \code{debianize} will automatically
  use some defaults: \describe{
  \item{Build.Depends.Indep}{\code{"debhelper (>> 4.1.0),
  r-base-dev (>= <R.vers>), cdbs"}}
  \item{Depends}{\code{"r-base (>= <R vers>)"}}
  \item{Maintainer}{Maintainer in \code{DESCRIPTION} (incl.
  e-mail address)} \item{Section}{\code{"math"}}
  \item{Priority}{\code{"optional"}} \item{Homepage}{URL in
  \code{DESCRIPTION}} } Refer to [1] for further available
  fields in the \code{./debian/control} file.}

  \item{actions}{Character vector, naming the actions to
  perform: \describe{ \item{"deb"}{Debianize the package
  sources.} \item{"bin"}{Build the Debian package.}
  \item{"src"}{Build a Debian source package (currently not
  implemented).} }}

  \item{overwrite}{Character vector, naming the files which
  should be updated: \describe{ \item{"changelog"}{Update
  \code{./debian/changelog}, but only if no entry for this
  package version and revision is there yet}
  \item{"control"}{Re-write \code{./debian/control}}
  \item{"copyright"}{Re-write \code{./debian/copyright}}
  \item{"rules"}{Re-write \code{./debian/rules}}
  \item{"gpg.key"}{Re-write \code{<key ID.asc>} in the
  repository (by default present keys are left unchanged)}
  }}

  \item{bin.opts}{Character string, options to pass through
  to \code{dpkg-buildpackage} for the \code{"bin"} action.}

  \item{arch}{Character string, architecture the package is
  build for.}

  \item{compat}{Integer value, specifying the
  \code{debhelper} compatibility level.}

  \item{gpg.key}{Character string, the GnuPG key ID for the
  key that should be used for signing the Release file
  (secure apt).  This key must be available in your
  keyring. Skipped if \code{NULL}.}

  \item{keep.build}{Logical. If \code{build.dir} is not
  \code{pck.source.dir}, work is done in generated folder
  with a random name. Usually it is removed afterwards,
  unless you set this option to \code{TRUE}.}

  \item{replace.dots}{Logical. The proposed Debian R Policy
  actually asks to replace all dots in package names by
  hyphens. However, this is implemented differently in
  \code{r-cran.mk} and will lead to unbuildable packages.
  So the default here is to ignore the policy draft and
  keep dots in package names, as is true for a lot of CRAN
  packages as well (code is law). In case you run into
  problems here (symptoms include a failing .deb build
  because the directory \code{build/<package name>} doesn't
  exist), try turning this switch. If \code{TRUE} dots will
  be replaced by hyphens in both source and binary package
  names. Note that building a package by calling this
  function should always work, because it will
  automatically create a symlink in the build directory if
  needed.}
}
\description{
  This function attempts to 'debianize' your R source
  package. This means, it will add a \code{debian}
  directory to sources' root directory, and populate it
  with needed files for Debian package building, as
  outlined in the Debian R Policy by Eddelbuettel & Bates
  (2003) and the Debian Policy Manual[1], version 3.9.3.1.
}
\details{
  The file \code{./debian/source/format} will also be
  created only once. The files \code{./debian/control},
  \code{./debian/copyright} and \code{./debian/rules} will
  be generated from the information found in the
  \code{DESCRIPTION} file of the R package. Once created,
  these files won't be touched again if they are not
  defined in the \code{overwrite} parameter. This enables
  you to save files from being re-written, e.g. if you
  altered them manually.

  The \code{./debian/changelog} is special here, as
  \code{overwrite} doesn't mean the whole file will be
  overwritten, but rather that the function checks if the
  changelog already contains an entry for this particular
  package version and revision, and only if this is not the
  case will add one at the beginning of the file, including
  the log entries defined by the \code{changelog} parameter
  (each string will become one log entry).

  The function will try to detect the license you specified
  in the \code{DESCRIPTION} file, and if it is one of the
  following licenses, generate some useful info on how to
  get the full licenseon a Debian system: \itemize{
  \item{Apache License} \item{Artisitic License} \item{BSD
  License} \item{GNU General Public License (GPL)}
  \item{GNU Lesser General Public License (LGPL)} }
}
\note{
  Please note that the package will always be built against
  the R version installed by your package management! Also,
  this function responds to
  \code{\link[roxyPackage:sandbox]{sandbox}}.
}
\section{Building the actual package}{
  If you're running the R session on a Debian based system,
  the function can build the debian package, but it would
  likely fail when it comes to signing the .changes/.dsc
  files, because \code{gpg} gets invoked without
  \code{"--no-tty"}. You'd have to sign those files later,
  e.g. with \code{debsign}, if you really need this.
  However, secure-apt can still be ensured, if you provide
  a valid GnuPG key ID from your keyring, which will then
  be used to sign the generated \code{Release} file. If not
  present yet, a copy of the public key will automatically
  be saved to the repository, in a file named \code{<key
  ID>.asc}.

  Package building is done in a temporal directory, and the
  source files a copied there first. Set
  \code{build.dir=pck.source.dir} if you want to build
  in-place instead.
}

\section{Package dependencies}{
  This function will make no attempts to guess what package
  dependencies must be fulfilled. That is, if the defaults
  don't fit (see below), then you must define these
  dependencies yourself via the \code{deb.description}
  parameter (setting appropriate values for fields like
  \code{Build.Depends.Indep} and \code{Depends}). In case
  your R package depends on other R packages, you will have
  to ensure that these are also available as Debian
  packages (and define them as dependencies), so the
  package management can take care of resolving these
  dependencies transparently. Otherwise users might have a
  hard time figuring out how to get your package to work,
  if the building process doesn't fail in the first place.
}

\section{Repository access}{
  After you debianized your package and built some Debian
  packages, \code{debianize} will prepare a Debain package
  repository in the specified directory (can be the same as
  used with \code{roxy.package}). You can now access it
  locally on your machine, or upload the whole thing to a
  web server etc. Basically, it should work if you add
  these lines to your repository configuration:

  \code{deb http://<URL you uploaded to>/deb <distribution>
  <component>}

  \code{deb-src http://<URL you uploaded to>/deb
  <distribution> <component>}
}
\examples{
\dontrun{
debianize(
  pck.source.dir="~/my_R_stuff/SquareTheCircle",
  repo.root="/var/www/repo",
  origin="other-doelle",
  revision=4,
  changelog=c("re-compiled docs"),
  deb.description=list(
    depends=c("r-base-dev (>> 2.12.0), r-cran-foreign"),
    maintainer="A. Sistent <sistent@eternalwondermaths.example.org>"),
  actions=c("deb"))
}
}
\references{
  Eddelbuettel, D. & Bates, D. (2003). \emph{Debian R
  Policy -- Draft Proposal v 0.1.3}.  Available from
  \url{http://lists.debian.org/debian-devel/2003/12/msg02332.html}

  [1] Debian Policy Manual:
  \url{http://www.debian.org/doc/debian-policy}
}
\seealso{
  \code{\link[roxyPackage:sandbox]{sandbox}} to run
  debianize() in a sandbox.
}

