% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_design_sample_size_calculator.R
\name{getPowerMeans}
\alias{getPowerMeans}
\title{Get Power Means}
\usage{
getPowerMeans(design = NULL, ..., normalApproximation = FALSE,
  meanRatio = FALSE, thetaH0 = ifelse(meanRatio, 1, 0),
  alternative = C_ALTERNATIVE_POWER_SIMULATION_DEFAULT,
  stDev = C_STDEV_DEFAULT, directionUpper = NA,
  maxNumberOfSubjects = NA_real_, groups = 2,
  allocationRatioPlanned = NA_real_)
}
\arguments{
\item{design}{The trial design. If no trial design is specified, a fixed sample size design is used. 
In this case, \code{alpha}, \code{beta}, \code{twoSidedPower}, and \code{sided} can be directly entered as argument.}

\item{...}{Ensures that all arguments are be named and 
that a warning will be displayed if unknown arguments are passed.}

\item{normalApproximation}{If \code{normalApproximation = TRUE} is specified, the variance is 
assumed to be known, default is FALSE, i.e., the calculations are performed with the t distribution.}

\item{meanRatio}{If \code{meanRatio = TRUE} is specified, the sample size for 
one-sided testing of H0: mu1/mu2 = thetaH0 is calculated, default is \code{FALSE}.}

\item{thetaH0}{The null hypothesis value. For one-sided testing, a value != 0 
(or a value != 1 for testing the mean ratio) can be specified, default is \code{0} or \code{1} for difference and ratio testing, respectively.}

\item{alternative}{The alternative hypothesis value. This can be a vector of assumed 
alternatives, default is \code{seq(0,1,0.2)}.}

\item{stDev}{The standard deviation, default is 1. If \code{meanRatio = TRUE} 
is specified, stDev defines the coefficient of variation sigma/mu2.}

\item{directionUpper}{Specifies the direction of the alternative, 
only applicable for one-sided testing, default is \code{TRUE}.}

\item{maxNumberOfSubjects}{\code{maxNumberOfSubjects > 0} needs to be specified.
If accrual time and accrual intensity is specified, this will be calculated.}

\item{groups}{The number of treatment groups (1 or 2), default is \code{2}.}

\item{allocationRatioPlanned}{The planned allocation ratio for a two treatment groups 
design, default is \code{1}.}
}
\value{
Returns a \code{\link{TrialDesignPlanMeans}} object.
}
\description{
Returns the power, stopping probabilities, and expected sample size for testing means in one or two samples at given sample size.
}
\details{
At given design the function calculates the power, stopping probabilities, and expected sample size, for testing means at given sample size.
In a two treatment groups design, additionally, an allocation ratio = n1/n2 can be specified. 
A null hypothesis value thetaH0 != 0 for testing the difference of two means or  
thetaH0 != 1 for testing the ratio of two means can be specified.
For the specified sample size, critical bounds and stopping for futility bounds are provided at the effect scale (mean, mean difference, or mean ratio, respectively)
}
\examples{

# Calculate the power, stopping probabilities, and expected sample size for testing H0: 
# mu1 - mu2 = 0 in a two-armed design 
# against a range of alternatives H1: mu1 - m2 = delta, delta = (0, 1, 2, 3, 4, 5), 
# standard deviation sigma = 8, maximum sample size N = 80 (both treatment arms), 
# and an allocation ratio n1/n2 = 2. The design is a three stage O'Brien & Fleming design 
# with non-binding futility bounds (-0.5, 0.5) for the two interims. 
# The computation takes into account that the t test is used (normalApproximation = FALSE). 
getPowerMeans(getDesignGroupSequential(alpha = 0.025, 
    sided = 1, futilityBounds = c(-0.5, 0.5)), 
    groups = 2, alternative = c(0:5), stDev = 8,
    normalApproximation = FALSE, maxNumberOfSubjects = 80, 
    allocationRatioPlanned = 2)

}
