% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_analysis_dataset.R
\name{getObservedInformationRates}
\alias{getObservedInformationRates}
\title{Get Observed Information Rates}
\usage{
getObservedInformationRates(
  dataInput,
  ...,
  maxInformation = NULL,
  informationEpsilon = NULL,
  stage = NA_integer_
)
}
\arguments{
\item{dataInput}{The dataset for which the information rates shall be recalculated.}

\item{...}{Ensures that all arguments (starting from the "...") are to be named and 
that a warning will be displayed if unknown arguments are passed.}

\item{maxInformation}{Positive integer value specifying the maximum information.}

\item{informationEpsilon}{Positive integer value specifying the information epsilon, which 
defines the maximum distance from the observed information to the maximum information that causes the final analysis.
Updates at the final analysis in case the observed information at the final 
analysis is smaller ("under-running") than the planned maximum information \code{maxInformation}.}

\item{stage}{The stage number (optional). Default: total number of existing stages in the data input.}
}
\description{
Recalculates the observed information rates from the specified dataset.
}
\details{
For means and rates the maximum information is the maximum number of subjects; 
for survival data it is the maximum number of events.
}
\seealso{
\itemize{
  \item \code{\link{getAnalysisResults}} for using \code{getObservedInformationRates} implicit,
  \item https://vignettes.rpact.org/html/rpact_boundary_update_example.html
}
}
