% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_simulation_enrichment_means.R
\name{getSimulationEnrichmentMeans}
\alias{getSimulationEnrichmentMeans}
\title{Get Simulation Enrichment Means}
\usage{
getSimulationEnrichmentMeans(
  design = NULL,
  ...,
  effectList = NULL,
  intersectionTest = c("Simes", "SpiessensDebois", "Bonferroni", "Sidak"),
  stratifiedAnalysis = TRUE,
  adaptations = NA,
  typeOfSelection = c("best", "rBest", "epsilon", "all", "userDefined"),
  effectMeasure = c("effectEstimate", "testStatistic"),
  successCriterion = c("all", "atLeastOne"),
  epsilonValue = NA_real_,
  rValue = NA_real_,
  threshold = -Inf,
  plannedSubjects = NA_integer_,
  allocationRatioPlanned = NA_real_,
  minNumberOfSubjectsPerStage = NA_real_,
  maxNumberOfSubjectsPerStage = NA_real_,
  conditionalPower = NA_real_,
  thetaH1 = NA_real_,
  stDevH1 = NA_real_,
  maxNumberOfIterations = 1000L,
  seed = NA_real_,
  calcSubjectsFunction = NULL,
  selectPopulationsFunction = NULL,
  showStatistics = FALSE
)
}
\arguments{
\item{design}{The trial design. If no trial design is specified, a fixed sample size design is used. 
In this case, Type I error rate \code{alpha}, Type II error rate \code{beta}, \code{twoSidedPower}, 
and \code{sided} can be directly entered as argument where necessary.}

\item{...}{Ensures that all arguments (starting from the "...") are to be named and 
that a warning will be displayed if unknown arguments are passed.}

\item{effectList}{List of subsets, prevalences, and effect sizes with columns and number of rows 
reflecting the different situations to consider (see examples).}

\item{intersectionTest}{Defines the multiple test for the intersection 
hypotheses in the closed system of hypotheses. 
Four options are available in enrichment designs: \code{"SpiessensDebois"}, \code{"Bonferroni"}, \code{"Simes"}, 
and \code{"Sidak"}, default is \code{"Simes"}.}

\item{stratifiedAnalysis}{Logical. For enrichment designs, typically a stratified analysis should be chosen.
For testing rates, also a non-stratified analysis based on overall data can be performed. 
For survival data, only a stratified analysis is possible (see Brannath et al., 2009), 
default is \code{TRUE}.}

\item{adaptations}{A logical vector of length \code{kMax - 1} indicating whether or not an adaptation takes 
place at interim k, default is \code{rep(TRUE, kMax - 1)}.}

\item{typeOfSelection}{The way the treatment arms or populations are selected at interim. 
Five options are available: \code{"best"}, \code{"rbest"}, \code{"epsilon"}, \code{"all"}, and \code{"userDefined"},
default is \code{"best"}.\cr
For \code{"rbest"} (select the \code{rValue} best treatment arms/populations), the parameter \code{rValue} has to be specified,
for \code{"epsilon"} (select treatment arm/population not worse than epsilon compared to the best), the parameter
\code{epsilonValue} has to be specified.
If \code{"userDefined"} is selected, \code{"selectArmsFunction"} or \code{"selectPopulationsFunction"} has to be specified.}

\item{effectMeasure}{Criterion for treatment arm/population selection, either based on test statistic 
(\code{"testStatistic"}) or effect estimate (difference for means and rates or ratio for survival) (\code{"effectEstimate"}), 
default is \code{"effectEstimate"}.}

\item{successCriterion}{Defines when the study is stopped for efficacy at interim. 
Two options are available: \code{"all"} stops the trial 
if the efficacy criterion is fulfilled for all selected treatment arms/populations, 
\code{"atLeastOne"} stops if at least one of the selected treatment arms/populations is shown to be 
superior to control at interim, default is \code{"all"}.}

\item{epsilonValue}{For \code{typeOfSelection = "epsilon"} (select treatment arm / population not worse than 
epsilon compared to the best), the parameter \code{epsilonValue} has to be specified. Must be a numeric of length 1.}

\item{rValue}{For \code{typeOfSelection = "rbest"} (select the \code{rValue} best treatment arms / populations), 
the parameter \code{rValue} has to be specified.}

\item{threshold}{Selection criterion: treatment arm / population is selected only if \code{effectMeasure} 
exceeds \code{threshold}, default is \code{-Inf}. 
\code{threshold} can also be a vector of length \code{activeArms} referring to 
a separate threshold condition over the treatment arms.}

\item{plannedSubjects}{\code{plannedSubjects} is a numeric vector of length \code{kMax} (the number of stages of the design) 
that determines the number of cumulated (overall) subjects when the interim stages are planned.
For two treatment arms, it is the number of subjects for both treatment arms. 
For multi-arm designs, \code{plannedSubjects} refers to the number of subjects per selected active arm.}

\item{allocationRatioPlanned}{The planned allocation ratio \code{n1 / n2} for a two treatment groups 
design, default is \code{1}. For multi-arm designs, it is the allocation ratio relating the active arm(s) to the control.}

\item{minNumberOfSubjectsPerStage}{When performing a data driven sample size recalculation, 
the numeric vector \code{minNumberOfSubjectsPerStage} with length kMax determines the 
minimum number of subjects per stage (i.e., not cumulated), the first element 
is not taken into account. For two treatment arms, it is the number of subjects for both treatment arms. 
For multi-arm designs \code{minNumberOfSubjectsPerStage} refers
to the minimum number of subjects per selected active arm.}

\item{maxNumberOfSubjectsPerStage}{When performing a data driven sample size recalculation, 
the numeric vector \code{maxNumberOfSubjectsPerStage} with length kMax determines the maximum number 
of subjects per stage (i.e., not cumulated), the first element is not taken into account.
For two treatment arms, it is the number of subjects for both treatment arms. 
For multi-arm designs \code{maxNumberOfSubjectsPerStage} refers
to the maximum number of subjects per selected active arm.}

\item{conditionalPower}{If \code{conditionalPower} together with \code{minNumberOfSubjectsPerStage} and 
\code{maxNumberOfSubjectsPerStage} (or \code{minNumberOfEventsPerStage} and \code{maxNumberOfEventsPerStage}
for survival designs) is specified, a sample size recalculation based on the specified conditional power is performed.
It is defined as the power for the subsequent stage given the current data. By default, 
the conditional power will be calculated under the observed effect size. Optionally, you can also specify \code{thetaH1} and
\code{stDevH1} (for simulating means), \code{pi1H1} and \code{pi2H1} (for simulating rates), or \code{thetaH1} (for simulating
hazard ratios) as parameters under which it is calculated and the sample size recalculation is performed.}

\item{thetaH1}{If specified, the value of the alternative under which 
the conditional power or sample size recalculation calculation is performed. Must be a numeric of length 1.}

\item{stDevH1}{If specified, the value of the standard deviation under which 
the conditional power or sample size recalculation calculation is performed,
default is the value of \code{stDev}. Must be a positive numeric of length 1.}

\item{maxNumberOfIterations}{The number of simulation iterations, default is \code{1000}. Must be a positive integer of length 1.}

\item{seed}{The seed to reproduce the simulation, default is a random seed.}

\item{calcSubjectsFunction}{Optionally, a function can be entered that defines the way of performing the sample size
recalculation. By default, sample size recalculation is performed with conditional power with specified
\code{minNumberOfSubjectsPerStage} and \code{maxNumberOfSubjectsPerStage} (see details and examples).}

\item{selectPopulationsFunction}{Optionally, a function can be entered that defines the way of how populations
are selected. This function is allowed to depend on \code{effectVector} with length \code{populations}
and \code{stage} (see examples).}

\item{showStatistics}{Logical. If \code{TRUE}, summary statistics of the simulated data
are displayed for the \code{print} command, otherwise the output is suppressed, default
is \code{FALSE}.}
}
\value{
Returns a \code{\link{SimulationResults}} object.
The following generics (R generic functions) are available for this object:
\itemize{
  \item \code{\link[=names.FieldSet]{names()}} to obtain the field names,
  \item \code{\link[=print.FieldSet]{print()}} to print the object,
  \item \code{\link[=summary.ParameterSet]{summary()}} to display a summary of the object,
  \item \code{\link[=plot.SimulationResults]{plot()}} to plot the object,
  \item \code{\link[=as.data.frame.ParameterSet]{as.data.frame()}} to coerce the object to a \code{\link[base]{data.frame}},
  \item \code{\link[=as.matrix.FieldSet]{as.matrix()}} to coerce the object to a \code{\link[base]{matrix}}.
}
}
\description{
Returns the simulated power, stopping and selection probabilities, conditional power,
and expected sample size or testing means in an enrichment design testing situation.
}
\details{
At given design the function simulates the power, stopping probabilities, selection probabilities,
and expected sample size at given number of subjects, parameter configuration, and population
selection rule in the enrichment situation.
An allocation ratio can be specified referring to the ratio of number of subjects in the active
treatment groups as compared to the control group.

The definition of \code{thetaH1} and/or \code{stDevH1} makes only sense if \code{kMax} > 1
and if \code{conditionalPower}, \code{minNumberOfSubjectsPerStage}, and
\code{maxNumberOfSubjectsPerStage} (or \code{calcSubjectsFunction}) are defined.

\code{calcSubjectsFunction}\cr
This function returns the number of subjects at given conditional power and conditional
critical value for specified testing situation. The function might depend on the variables
\code{stage},
\code{selectedPopulations},
\code{plannedSubjects},
\code{allocationRatioPlanned},
\code{minNumberOfSubjectsPerStage},
\code{maxNumberOfSubjectsPerStage},
\code{conditionalPower},
\code{conditionalCriticalValue},
\code{overallEffects}, and
\code{stDevH1}.
The function has to contain the three-dots argument '...' (see examples).
}
\section{How to get help for generic functions}{

Click on the link of a generic in the list above to go directly to the help documentation of 
the \code{rpact} specific implementation of the generic. 
Note that you can use the R function \code{\link[utils]{methods}} to get all the methods of a generic and 
to identify the object specific name of it, e.g., 
use \code{methods("plot")} to get all the methods for the \code{plot} generic. 
There you can find, e.g., \code{plot.AnalysisResults} and 
obtain the specific help documentation linked above by typing \code{?plot.AnalysisResults}.
}

\examples{
\donttest{
# Assess a population selection strategy with one subset population.
# If the subset is better than the full population, then the subset
# is selected for the second stage, otherwise the full. Print and plot
# design characteristics.

# Define design
ds <- getDesignInverseNormal(kMax = 2)

# Define subgroups and their prevalences
subGroups <- c("S", "R") # fixed names!
prevalences <- c(0.2, 0.8)

# Define effect matrix and variability
effectR <- 0.2
m <- c()
for (effectS in seq(0, 0.5, 0.25)) {
    m <- c(m, effectS, effectR)
}
effects <- matrix(m, byrow = TRUE, ncol = 2)
stDev <- c(0.4, 0.8)

# Define effect list
el <- list(subGroups=subGroups, prevalences=prevalences, stDevs = stDev, effects = effects)

# Perform simulation
simResultsPE <- getSimulationEnrichmentMeans(design = ds,
    effectList = el, plannedSubjects = c(50, 100),
    maxNumberOfIterations = 100)
print(simResultsPE)

# Assess the design characteristics of a user defined selection
# strategy in a three-stage design with no interim efficacy stop
# using the inverse normal method for combining the stages.
# Only the second interim is used for a selecting of a study
# population. There is a small probability for stopping the trial
# at the first interim.

# Define design
ds <- getDesignInverseNormal(typeOfDesign = "noEarlyEfficacy", kMax = 3)

# Define selection function
mySelection <- function(effectVector, stage) {
    selectedPopulations <- rep(TRUE, 3)
    if (stage == 2) {
        selectedPopulations <- (effectVector >= c(1, 2, 3))
    }
    return(selectedPopulations)
}

# Define subgroups and their prevalences
subGroups <- c("S1", "S12", "S2", "R")   # fixed names!
prevalences <- c(0.2, 0.3, 0.4, 0.1)

effectR <- 1.5
effectS12 = 5
m <- c()
for (effectS1 in seq(0, 5, 1)) {
    for (effectS2 in seq(0, 5, 1)) {
        m <- c(m, effectS1, effectS12, effectS2, effectR)
    }
}
effects <- matrix(m, byrow = TRUE, ncol = 4)
stDev <- 10

# Define effect list
el <- list(subGroups=subGroups, prevalences=prevalences, stDevs = stDev, effects = effects)

# Perform simulation
simResultsPE <- getSimulationEnrichmentMeans(design = ds,
    effectList = el,
    typeOfSelection = "userDefined",
    selectPopulationsFunction = mySelection,
    intersectionTest = "Simes",
    plannedSubjects = c(50, 100, 150),
    maxNumberOfIterations = 100)
print(simResultsPE)
if (require(ggplot2)) plot(simResultsPE, type = 3)
}

}
