% Generated by roxygen2 (4.0.1): do not edit by hand
\name{rpf.dLL}
\alias{rpf.dLL}
\alias{rpf.dLL,rpf.base,numeric,NULL,numeric-method}
\alias{rpf.dLL,rpf.base,numeric,numeric,numeric-method}
\alias{rpf_dLL_wrapper}
\title{Item parameter derivatives}
\usage{
rpf.dLL(m, param, where, weight)
}
\arguments{
\item{m}{item model}

\item{param}{item parameters}

\item{where}{location in the latent space}

\item{weight}{per outcome weights (typically derived by observation)}
}
\value{
first and second order partial derivatives of the log
likelihood evaluated at \code{where}. For p parameters, the first
p values are the first derivative and the next p(p+1)/2 columns
are the lower triangle of the second derivative.
}
\description{
Evaluate the partial derivatives of the log likelihood with
respect to each parameter at \code{where} with \code{weight}.
}
\details{
It is not easy to write an example for this function. To evaluate
the derivative, you need to sum the derivatives across a
quadrature. You also need response outcome weights at each
quadrature point. It is not anticipated that this function will be
often used in R code. It's mainly to expose a C-level function for
occasional debugging.
}
\seealso{
The numDeriv package.
}

