% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_phylopic.R, R/phylopic_utils.R
\name{get_phylopic}
\alias{get_phylopic}
\alias{print.Picture}
\alias{print.phylopic}
\title{Retrieve an image for a given PhyloPic uuid}
\usage{
get_phylopic(uuid = NULL, format = "vector", height = 512, preview = FALSE)

\method{print}{Picture}(x, ...)

\method{print}{phylopic}(x, ...)
}
\arguments{
\item{uuid}{\code{character}. A PhyloPic image uuid.}

\item{format}{\code{character}. Format of the image. To return a vectorized
image, use "vector". To return a rasterized image, use "raster" and specify
a desired \code{height}.}

\item{height}{\code{numeric}. If \code{format} is "raster", this is the desired
height of the raster image in pixels. This is ignored if \code{format} is
"vector".}

\item{preview}{\code{logical}. If \code{preview} is \code{TRUE}, the returned
image is plotted. Defaults to \code{FALSE}.}

\item{x}{A \link[grImport2:Picture-class]{Picture} or png array object, e.g.,
from using \code{\link[=get_phylopic]{get_phylopic()}}.}

\item{...}{Ignored}
}
\value{
If \code{format} is "vector", a \link[grImport2:Picture-class]{Picture} object
is returned. If \code{format} is "raster", a png array representing the
rasterized image is returned. Either way, the uuid and download url are
included as the "uuid" and "url" attributes, respectively.
}
\description{
This retrieves a PhyloPic silhouette as a vectorized or rasterized object.
}
\details{
The \code{height} argument is ignored if the \code{format} argument is not set
to "raster". If \code{format} is "raster", the \code{height} argument specifies the
height of the desired raster object. The width of this raster object will
be determined by the original aspect ratio of the silhouette. If a
pre-rendered raster exists with the desired dimensions, it will be
downloaded from PhyloPic. If not, the vector image from PhyloPic will be
used to render a raster object of the desired size.
}
\examples{
# uuid
uuid <- "9fae30cd-fb59-4a81-a39c-e1826a35f612"

# Get data for an image
img_svg <- get_phylopic(uuid, format = "vector") # vector format
img_png <- get_phylopic(uuid, format = "raster") # raster format
}
