% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fulltext.R
\name{plos_fulltext}
\alias{plos_fulltext}
\alias{print.plosft}
\title{Get full text xml of PLOS papers given a DOI}
\usage{
plos_fulltext(doi, ...)

\method{print}{plosft}(x, ...)
}
\arguments{
\item{doi}{One or more DOIs}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}

\item{x}{Input to print method}
}
\value{
Character string of XML.
}
\description{
Get full text xml of PLOS papers given a DOI
}
\examples{
\dontrun{
plos_fulltext(doi='10.1371/journal.pone.0086169')
plos_fulltext(c('10.1371/journal.pone.0086169','10.1371/journal.pbio.1001845'))
dois <- searchplos(q = "*:*", fq=list('doc_type:full', 'article_type:"Research Article"'), 
limit=3)$data$id
out <- plos_fulltext(dois)
out[dois[1]]
out[1:2]

# Extract text from the XML strings
library("XML")
lapply(out[2:3], function(x){
 tmp <- xmlParse(x)
 xpathApply(tmp, "//ref-list")
})

# Make a text corpus
library("tm")
out_parsed <- lapply(out, function(x){
 tmp <- xmlParse(x)
 xpathApply(tmp, "//body", xmlValue)
})
tmcorpus <- Corpus(VectorSource(out_parsed))
(dtm <- DocumentTermMatrix(tmcorpus))
findFreqTerms(dtm, lowfreq = 50)
}
}

