% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{AgesOfEvents}
\alias{AgesOfEvents}
\title{Event probabilities against calendar age}
\usage{
AgesOfEvents(
  window,
  move,
  set = get("info"),
  plot.steps = FALSE,
  BCAD = set$BCAD,
  age.lab = c(),
  yr.lab = age.lab,
  age.lim = c(),
  yr.lim = age.lim,
  prob.lab = "probability",
  prob.lim = c(),
  rotate.axes = FALSE,
  rev.age = TRUE,
  rev.yr = rev.age,
  yaxs = "i",
  bty = "l"
)
}
\arguments{
\item{window}{Width of the window.}

\item{move}{Step size with which the window moves.}

\item{set}{Detailed information of the current run, stored within this session's memory as variable \code{info}.}

\item{plot.steps}{Plot probability values step-wise (defaults to \code{plot.steps=FALSE}, which plots smooth curves instead).}

\item{BCAD}{The calendar scale of graphs and age output-files is in \code{cal BP} by default, but can be changed to BC/AD using \code{BCAD=TRUE}.}

\item{age.lab}{The labels for the calendar axis (default \code{age.lab="cal BP"} or \code{"BC/AD"} if \code{BCAD=TRUE}).}

\item{yr.lab}{Deprecated - use age.lab instead}

\item{age.lim}{Minimum and maximum calendar age ranges, calculated automatically by default (\code{age.lim=c()}).}

\item{yr.lim}{Deprecated - use age.lim instead}

\item{prob.lab}{Label of the probability axis (default \code{prob.lab="probability"}).}

\item{prob.lim}{Limits of the probability axis (calculated automatically by default).}

\item{rotate.axes}{The default of plotting age on the horizontal axis and event probability on the vertical one can be changed with \code{rotate.axes=TRUE}.}

\item{rev.age}{The direction of the age axis, which can be reversed using \code{rev.age=TRUE}.}

\item{rev.yr}{Deprecated - use rev.age instead}

\item{yaxs}{Extension of the y-axis. Defaults to the exact ranges of the probability values. White space can be added to the vertical axis using \code{yaxs="r"}.}

\item{bty}{Type of box to be drawn around plots. Draw a box around the graph (\code{"n"} for none, and \code{"l"}, \code{"7"},
\code{"c"}, \code{"u"}, "]" or \code{"o"} for correspondingly shaped boxes).}
}
\value{
The resulting probabilities are plotted and saved within the core's folder (file names ending with the window width and "_probs.txt").
}
\description{
Plot probability curves for events in the core, expressed against calendar age.
}
\details{
Probabilities of depths with 'events' in an age-modelled core can be plotted against time, taking into account
chronological uncertainties (Blaauw et al. 2007). Such events could be for example core depths at which proxies
indicate changes toward wetter local conditions. This can be expressed as values between 0 (no event) and 1 (event at 100\% probability)
for each depth.

Blaauw et al. 2010 propose to estimate probabilities of events by finding specific proxy features such as increasing curves.
Probabilities are then estimated through resampling from the proxy values, where low to modest rises of proxy curves result
in low event probabilities, and clear proxy rises in high probabilities. A smooth spline can be applied to adapt the balance of short-term vs long-term events. To calculate the event probabilities,
produce a file with two columns (depth and corresponding proxy-derived probabilities, separated by white spaces).
 Do not provide headers at the file's first line, and save the file with extension "_events.txt" within the core's Bacon folder. See Cores/MSB2K/MSB2K_events.txt (or Plum_runs/MSB2K/MSB2K_events.txt) for an example. Events are calculated as the probability that an event took place within specific time windows - or more specifically, that the Bacon age-depth model puts depths with assigned event probabilities in that time window.

does not yet deal correctly with hiatuses.
}
\references{
Blaauw, M., Christen, J.A., Mauquoy, D., van der Plicht, J., Bennett, K.D. (2007) Testing the timing of radiocarbon-dated events between proxy archives. _The Holocene_, *17*, 283-288.
Blaauw, M., Wohlfarth, B., Christen, J.A., Ampel, L., Veres, D., Hughen, K.A., Preusser, F., Svensson, A. (2010) Were last glacial climate events simultaneous between Greenland and France? A quantitative comparison using non-tuned chronologies. _Journal of Quaternary Science_ *25*, 387-394.
\url{https://projecteuclid.org/euclid.ba/1339616472}
}
\seealso{
\url{http://www.qub.ac.uk/chrono/blaauw/manualBacon_2.3.pdf}
}
\author{
Maarten Blaauw, J. Andres Christen
}
