% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pgSRID.R
\name{pgSRID}
\alias{pgSRID}
\title{Find (or create) PostGIS SRID based on CRS object.}
\usage{
pgSRID(conn, crs, create.srid = FALSE, new.srid = NULL)
}
\arguments{
\item{conn}{A connection object to a PostgreSQL database.}

\item{crs}{CRS object, created through a call to
\code{\link[sp]{CRS}}.}

\item{create.srid}{Logical. If no matching SRID is found, should a new
SRID be created? User must have write access on
\code{spatial_ref_sys} table.}

\item{new.srid}{Integer. Optional SRID to give to a newly created
SRID. If left NULL (default), the next open value of
\code{srid} in \code{spatial_ref_sys} between 880001 and
889999 will be used.}
}
\value{
SRID code (integer).
}
\description{
This function takes \code{\link[sp]{CRS}}-class object and a
PostgreSQL database connection (with PostGIS extension), and
returns the matching SRID(s) for that CRS. If a match is not
found, a new entry can be created in the PostgreSQL
\code{spatial_ref_sys} table using the parameters specified by the
CRS. New entries will be created with \code{auth_name =
'rpostgis_custom'}, with the default value being the next open value
between 880001-889999 (a different SRID value can be entered if desired.)
}
\examples{
\dontrun{
drv <- dbDriver("PostgreSQL")
conn <- dbConnect(drv, dbname = "dbname", host = "host", port = "5432",
    user = "user", password = "password")
(crs <- CRS("+proj=longlat"))
pgSRID(conn, crs)
(crs2 <- CRS(paste("+proj=stere", "+lat_0=52.15616055555555 +lon_0=5.38763888888889",
    "+k=0.999908 +x_0=155000 +y_0=463000", "+ellps=bessel",
    "+towgs84=565.237,50.0087,465.658,-0.406857,0.350733,-1.87035,4.0812",
    "+units=m")))
pgSRID(conn, crs2, create.srid = TRUE)
}
}
\author{
David Bucklin \email{david.bucklin@gmail.com}
}
