% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppo_data.R
\name{ppo_data}
\alias{ppo_data}
\title{Access Data From the Global Plant Phenology Data Portal}
\usage{
ppo_data(
  genus = NULL,
  specificEpithet = NULL,
  termID = NULL,
  fromYear = NULL,
  toYear = NULL,
  fromDay = NULL,
  toDay = NULL,
  bbox = NULL,
  limit = NULL,
  timeLimit = 60
)
}
\arguments{
\item{genus}{(string) a plant genus name}

\item{specificEpithet}{(string) a plant specific epithet}

\item{termID}{(string) A single termID from the plant phenology ontology.
See the \code{\link{ppo_terms}} function for more information.}

\item{fromYear}{(integer) return data from the specified year}

\item{toYear}{(integer) return data up to and including the specified year}

\item{fromDay}{(integer) return data starting from the specified day}

\item{toDay}{(integer) return data up to and including the specified day}

\item{bbox}{(string) return data within a bounding box. Format is
\code{lat,long,lat,long} and is structured as a string.  Use this website:
http://boundingbox.klokantech.com/ to quickly grab a bbox (set format on
bottom left to csv and be sure to switch the order from
long, lat, long, lat to lat, long, lat, long).}

\item{limit}{(integer) limit returned data to a specified number of records}

\item{timeLimit}{(integer) set the limit ofthe amount of time to wait for a response}
}
\value{
Return value containing a list with the following components:
\itemize{
 \item {`data`: A data frame containing data}
 \item {`readme`: A string with information about the return package}
 \item {`citation`: A string with citation information}
 \item {`number_possible`: An integer with total possible results}
 \item {`status_code`: An integer with status code returned from server}
}
}
\description{
Access data from the global plant phenology data portal
(PPO data portal)
}
\details{
The ppo_data function returns a list containing the following information:
a readme file, citation information, a data frame with data, an integer with
the number of records returned and a status code.  The function is called with
parameters that correspond to values contained in the data itself which act
as a filter on the returned record set.
}
\examples{

r1 <- ppo_data(genus = "Quercus", termID='obo:PPO_0002313', limit=10, timeLimit = 4)

r2 <- ppo_data(fromDay = 1, toDay = 100, bbox="37,-120,38,-119", limit=10, timeLimit = 4)

my_data_frame <- r2$data
}
\keyword{data}
\keyword{download}
\keyword{phenology}
\keyword{plant}
