% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppo_terms.R
\name{ppo_terms}
\alias{ppo_terms}
\title{Access Terms From the Plant Phenology Ontology}
\usage{
ppo_terms(present = FALSE, absent = FALSE, timeLimit = 2)
}
\arguments{
\item{present}{(boolean) If TRUE then return all "present" phenological stages}

\item{absent}{(boolean) IF TRUE then return all "absent" phenological stages.}

\item{timeLimit}{(integer) set the limit ofthe amount of time to wait for a response}
}
\value{
data.frame
}
\description{
Access present and absent terms from the Plant Phenology Ontology
}
\details{
The ppo_terms function returns terms from the Plant Phenology Ontology (PPO).
The function only accepts parameters for "present" or "absent" terms.
The response populates a data frame with: termID, label, description, and
URI.  Use the termID values in submitting termID values to the
\code{\link{ppo_data}} function.  The label and description fields are
extracted from the Plant Phenology Ontology and are useful in
determining the proper term to query on.  The URI field contains a link to
the term itself which is useful for determining superclass and subclass
relationships for each term.
For more information on the PPO ontology itself, we suggest loading the PPO
\url{https://github.com/PlantPhenoOntology/ppo} with
protege \url{https://protege.stanford.edu/}
}
\examples{
presentTerms <- ppo_terms(present = TRUE, timeLimit = 1)

absentTerms <- ppo_terms(absent = TRUE, timeLimit = 1)
}
\keyword{lookup}
\keyword{trait}
