% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{list_functions}
\alias{list_functions}
\alias{pluck}
\alias{pluck_apply}
\alias{pick}
\alias{pick_apply}
\title{Higher-order functions for dealing with lists}
\usage{
pluck(key)

pluck_apply(key, xss)

pick(keys)

pick_apply(keys, xss)
}
\arguments{
\item{key}{the name of a value in a list}

\item{xss}{a list of lists}

\item{keys}{a character vector of names in a list}
}
\value{
\code{pluck} returns an unnamed value and \code{pluck_apply} returns
  a list of unnamed values. \code{pick} returns a simplified version of the
  original list. \code{pick_apply} returns a list of simplified lists.
}
\description{
These functions were inspired by underscore.js.
}
\details{
\itemize{ \item \code{pluck}: Pluck a named value from a list \item
  \code{pick}: Simplify a list by picking out whitelisted names}

  The simple versions of \code{pluck} and \code{pick} are curried functions,
  meaning that they return a function which can be applied to a list. See the
  syntax in the usage section.
}
\keyword{internal}
