% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics-ANTsTransform.R
\name{as_ANTsTransform}
\alias{as_ANTsTransform}
\alias{as_ANTsTransform.default}
\alias{as_ANTsTransform.ants.core.ants_transform.ANTsTransform}
\alias{as_ANTsTransform.ants.core.ants_image.ANTsImage}
\alias{as_ANTsTransform.numpy.ndarray}
\alias{as_ANTsTransform.character}
\title{Convert to \code{'ANTsTransform'}}
\usage{
as_ANTsTransform(x, ...)

\method{as_ANTsTransform}{default}(x, dimension = 3, ...)

\method{as_ANTsTransform}{ants.core.ants_transform.ANTsTransform}(x, ...)

\method{as_ANTsTransform}{ants.core.ants_image.ANTsImage}(x, ...)

\method{as_ANTsTransform}{numpy.ndarray}(x, ...)

\method{as_ANTsTransform}{character}(x, ...)
}
\arguments{
\item{x}{'affine' matrix or \code{'numpy'} array, character path to the
matrix, \code{'ANTsTransform'}, \code{'ANTsImage'} as displacement field.}

\item{...}{passed to other methods}

\item{dimension}{expected transform space dimension; default is 3}
}
\value{
An \code{'ANTsTransform'} object
}
\description{
Convert to \code{'ANTsTransform'}
}
\examples{

if(interactive() && ants_available()) {

  mat <- matrix(c(
    0, -1, 0, 128,
    1, 0, 0, -128,
    0, 0, -1, 128,
    0, 0,  0,   1
  ), ncol = 4, byrow = TRUE)

  trans <- as_ANTsTransform(mat)
  trans

  # apply transform
  trans$apply_to_point(c(120, 400, 1))

  # same results
  mat \%*\% c(120, 400, 1, 1)

  trans[] == mat

}

}
