% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mainFunctions.R
\name{rq.group.pen.cv}
\alias{rq.group.pen.cv}
\title{Performs cross validation for a group penalty. 
#'}
\usage{
rq.group.pen.cv(
  x,
  y,
  tau = 0.5,
  groups = 1:ncol(x),
  lambda = NULL,
  a = NULL,
  cvFunc = NULL,
  nfolds = 10,
  foldid = NULL,
  groupError = TRUE,
  cvSummary = mean,
  tauWeights = rep(1, length(tau)),
  printProgress = FALSE,
  weights = NULL,
  ...
)
}
\arguments{
\item{x}{Matrix of predictors.}

\item{y}{Vector of responses.}

\item{tau}{Vector of quantiles.}

\item{groups}{Vector of group assignments for the predictors.}

\item{lambda}{Vector of lambda values, if set to NULL they will be generated automatically.}

\item{a}{Vector of the other tuning parameter values.}

\item{cvFunc}{Function used for cross-validation error, default is quantile loss.}

\item{nfolds}{Number of folds used for cross validation.}

\item{foldid}{Fold assignments, if not set this will be randomly created.}

\item{groupError}{If errors are to be reported as a group or as the average for each fold.}

\item{cvSummary}{The}

\item{tauWeights}{Weights for the tau penalty.}

\item{printProgress}{If set to TRUE will print which fold the process is working on.}

\item{weights}{Weights for the quantile loss function. Used in both model fitting and cross-validation.}

\item{...}{Additional parameters that will be sent to rq.group.pen().}
}
\value{
\itemize{
\item{cverr}{Matrix of cvSummary function, default is average, cross-validation error for each model, tau and a combination, and lambda.}
\item{cvse}{Matrix of the standard error of cverr foreach model, tau and a combination, and lambda.}
\item{fit}{The rq.pen.seq object fit to the full data.}
\item{btr}{A data.table of the values of a and lambda that are best as determined by the minimum cross validation error and the one standard error rule, which fixes a. In btr the values of lambda and a are selected seperately for each quantile.}
\item{gtr}{A data.table for the combination of a and lambda that minimize the cross validation error across all tau.}
\item{gcve}{Group, across all quantiles, cross-validation error results for each value of a and lambda.}
\item{call}{Original call to the function.}
}
}
\description{
Performs cross validation for a group penalty. 
#'
}
\examples{
set.seed(1)
x <- matrix(rnorm(100*8,sd=1),ncol=8)
y <- 1 + x[,1] + 3*x[,3] - x[,8] + rt(100,3)
g <- c(1,1,1,1,2,2,3,3)
tvals <- c(.25,.75)
\dontrun{
m1 <- rq.group.pen.cv(x,y,tau=c(.1,.3,.7),groups=g)
m2 <- rq.group.pen.cv(x,y,penalty="gAdLASSO",tau=c(.1,.3,.7),groups=g)
m3 <- rq.group.pen.cv(x,y,penalty="gSCAD",tau=c(.1,.3,.7),a=c(3,4,5),groups=g)
m4 <- rq.group.pen.cv(x,y,penalty="gMCP",tau=c(.1,.3,.7),a=c(3,4,5),groups=g)
}
}
\author{
Ben Sherwood, \email{ben.sherwood@ku.edu} and Shaobo Li \email{shaobo.li@ku.edu}
}
