% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sql_node.R
\name{sql_node}
\alias{sql_node}
\title{Make a general SQL node.}
\usage{
sql_node(source, exprs, ..., mods = NULL, orig_columns = TRUE)
}
\arguments{
\item{source}{source to work from.}

\item{exprs}{SQL expressions}

\item{...}{force later arguments to bind by name}

\item{mods}{SQL modifiers (GROUP BY, ORDER BY, and so on)}

\item{orig_columns}{logical if TRUE select all original columns.}
}
\value{
sql node.
}
\description{
Make a general SQL node.
}
\examples{

if (requireNamespace("RSQLite", quietly = TRUE)) {
  # example database connection
  my_db <- DBI::dbConnect(RSQLite::SQLite(),
                          ":memory:")
  # load up example data
  d <- dbi_copy_to(
    my_db, 'd',
    data.frame(v1 = c(1, 2, NA, 3),
               v2 = c(NA, "b", NA, "c"),
               v3 = c(NA, NA, 7, 8),
               stringsAsFactors = FALSE))

  # look at table
  execute(my_db, d)

  # get list of columns
  vars <- column_names(d)
  print(vars)

  # build a NA/NULLs per-row counting expression.
  # names are "quoted" by wrapping them with as.name().
  # constants can be quoted by an additional list wrapping.
  expr <- lapply(vars,
                 function(vi) {
                   list("+ (CASE WHEN (",
                        as.name(vi),
                        "IS NULL ) THEN 1.0 ELSE 0.0 END)")
                 })
  expr <- unlist(expr, recursive = FALSE)
  expr <- c(list(0.0), expr)
  cat(paste(unlist(expr), collapse = " "))

  # instantiate the operator node
  op_tree <- d \%.>\%
    sql_node(., "num_missing" := list(expr))
  cat(format(op_tree))

  # examine produced SQL
  sql <- to_sql(op_tree, my_db)
  cat(sql)

  # execute
  execute(my_db, op_tree) \%.>\%
     print(.)

  # whole process wrapped in convenience node
  op_tree2 <- d \%.>\%
    count_null_cols(., vars, "nnull")
  execute(my_db, op_tree2) \%.>\%
    print(.)

  DBI::dbDisconnect(my_db)
}

}
