mixed.solve <- function (y, Z, K = NULL, X = NULL, method = "REML", bounds = c(1e-09,1e+09), SE = FALSE, return.Hinv = FALSE) {
pi <- 3.14159
n <- length(y)
y <- matrix(y,n,1)
if (is.null(X)) {
p <- 1
X <- matrix(rep(1,n),n,1)
}
p <- ncol(X)
if (is.null(p)) {
p <- 1
X <- matrix(X,length(X),1)
}
m <- ncol(Z)
if (is.null(m)) {
m <- 1
Z <- matrix(Z,length(Z),1)
}
stopifnot(nrow(Z) == n)
stopifnot(nrow(X) == n)
if (!is.null(K)) {
	stopifnot(nrow(K) == m)
	stopifnot(ncol(K) == m)
}
XtX <- crossprod(X, X)
rank.X <- qr(XtX)$rank
stopifnot(p == rank.X)
XtXinv <- solve(XtX)
S <- diag(n) - tcrossprod(X%*%XtXinv,X)
if (n <= m + p) {
  spectral.method <- "eigen"
} else {
  spectral.method <- "cholesky"
  if (!is.null(K)) {
  	B <- try(chol(K),silent=TRUE)
  	if (class(B)=="try-error") {
         # K not positive definite
         eig.K <- eigen(K,symmetric=TRUE)
         if (min(eig.K$values) < -1e-6) {
           stop("K not positive semi-definite")
         } else {
         # use pivoting
         options(warn=-1) #disable warning
         B <- chol(K,pivot=TRUE)
         options(warn=0)
         pivot <- attr(B,"pivot")         
         B <- B[,order(pivot)]         
         } #if min(eig.K)
     } #if class(B)
  } # if is.null
} 
if (spectral.method=="cholesky") {
if (is.null(K)) {
	ZBt <- Z
} else {
	ZBt <- tcrossprod(Z,B) 
}
svd.ZBt <- svd(ZBt,nu=n)
U <- svd.ZBt$u
phi <- c(svd.ZBt$d^2,rep(0,n-m))
SZBt <- S %*% ZBt
svd.SZBt <- svd(SZBt)
QR <- qr(cbind(X,svd.SZBt$u))
Q <- qr.Q(QR,complete=TRUE)[,(p+1):n]
R <- qr.R(QR)[p+1:m,p+1:m]
theta <- c(forwardsolve(t(R^2),svd.SZBt$d^2),rep(0,n-p-m))
} else {
# spectral.method is "eigen"
offset <- sqrt(n)
if (is.null(K)) {
	Hb <- tcrossprod(Z,Z) + offset*diag(n)
} else {
	Hb <- tcrossprod(Z%*%K,Z) + offset*diag(n)
}
Hb.system <- eigen(Hb, symmetric = TRUE)
phi <- Hb.system$values - offset
if (min(phi) < -1e-6) {stop("K not positive semi-definite.")}
U <- Hb.system$vectors
SHbS <- S %*% Hb %*% S
SHbS.system <- eigen(SHbS, symmetric = TRUE)
theta <- SHbS.system$values[1:(n - p)] - offset
Q <- SHbS.system$vectors[, 1:(n - p)]
}  #if (n > m)
omega <- crossprod(Q, y)
omega.sq <- omega^2
if (method == "ML") {
f.ML <- function(lambda, n, theta, omega.sq, phi) {
 n * log(sum(omega.sq/(theta + lambda))) + sum(log(phi + lambda))
}
soln <- optimize(f.ML, interval = bounds, n, theta, omega.sq, phi)
lambda.opt <- soln$minimum
df <- n
} else {
f.REML <- function(lambda, n.p, theta, omega.sq) {
 n.p * log(sum(omega.sq/(theta + lambda))) + sum(log(theta + lambda))
}
soln <- optimize(f.REML, interval = bounds, n - p, theta, omega.sq)
lambda.opt <- soln$minimum
df <- n - p
} #if method
Vu.opt <- sum(omega.sq/(theta + lambda.opt))/df
Ve.opt <- lambda.opt * Vu.opt
Hinv <- U %*% (t(U)/(phi+lambda.opt))
W <- crossprod(X,Hinv%*%X)
beta <- solve(W,crossprod(X,Hinv%*%y))
if (is.null(K)) {
	KZt <- t(Z)
} else {
	KZt <- tcrossprod(K,Z)
}
KZt.Hinv <- KZt %*% Hinv
u <- KZt.Hinv %*% (y - X%*%beta)
LL = -0.5 * (soln$objective + df + df * log(2 * pi/df))
if (!SE) {
  if (return.Hinv) {
    list(Vu = Vu.opt, Ve = Ve.opt, beta = as.vector(beta), u = as.vector(u), LL = LL, Hinv = Hinv)
  } else {
    list(Vu = Vu.opt, Ve = Ve.opt, beta = as.vector(beta), u = as.vector(u), LL = LL)
  }
} else {
  Winv <- solve(W)
  beta.SE <- sqrt(Vu.opt*diag(Winv))
  WW <- tcrossprod(KZt.Hinv,KZt)
  WWW <- KZt.Hinv%*%X
  if (is.null(K)) {
	u.SE <- sqrt(Vu.opt * (rep(1,m) - diag(WW) + diag(tcrossprod(WWW%*%Winv,WWW))))	
  } else {
	u.SE <- sqrt(Vu.opt * (diag(K) - diag(WW) + diag(tcrossprod(WWW%*%Winv,WWW))))
  }
  if (return.Hinv) {
    list(Vu = Vu.opt, Ve = Ve.opt, beta = as.vector(beta), beta.SE = as.vector(beta.SE), u = as.vector(u), u.SE = as.vector(u.SE), LL = LL, Hinv = Hinv)
  } else {
    list(Vu = Vu.opt, Ve = Ve.opt, beta = as.vector(beta), beta.SE = as.vector(beta.SE), u = as.vector(u), u.SE = as.vector(u.SE), LL = LL)
  }
}
}