/*
 * Decompiled with CFR 0.152.
 */
package com.github.egonw.rrdf;

import com.github.egonw.rrdf.StringMatrix;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.shared.PrefixMapping;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class RJenaHelper {
    public static Model newRdf() throws Exception {
        return ModelFactory.createOntologyModel();
    }

    public static Model loadRdf(String string, String string2) throws Exception {
        OntModel ontModel = ModelFactory.createOntologyModel();
        File file = new File(string);
        FileInputStream fileInputStream = new FileInputStream(file);
        ontModel.read((InputStream)fileInputStream, "", string2);
        return ontModel;
    }

    public static String dump(Model model) {
        StringBuffer stringBuffer = new StringBuffer();
        StmtIterator stmtIterator = model.listStatements();
        while (stmtIterator.hasNext()) {
            Statement statement = stmtIterator.nextStatement();
            RDFNode rDFNode = statement.getObject();
            stringBuffer.append(statement.getSubject().getLocalName()).append(' ').append(statement.getPredicate().getLocalName()).append(' ').append(rDFNode instanceof Resource ? rDFNode.toString() : '\"' + rDFNode.toString() + "\"").append('\n');
        }
        return stringBuffer.toString();
    }

    public static int tripleCount(Model model) {
        return (int)model.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StringMatrix sparql(Model model, String string) throws Exception {
        StringMatrix stringMatrix = null;
        Query query = QueryFactory.create((String)string);
        PrefixMapping prefixMapping = query.getPrefixMapping();
        QueryExecution queryExecution = QueryExecutionFactory.create((Query)query, (Model)model);
        try {
            ResultSet resultSet = queryExecution.execSelect();
            stringMatrix = RJenaHelper.convertIntoTable(prefixMapping, resultSet);
        }
        finally {
            queryExecution.close();
        }
        return stringMatrix;
    }

    private static StringMatrix convertIntoTable(PrefixMapping prefixMapping, ResultSet resultSet) {
        StringMatrix stringMatrix = new StringMatrix();
        int n = 0;
        int n2 = 0;
        while (resultSet.hasNext()) {
            n2 = 0;
            ++n;
            QuerySolution querySolution = resultSet.nextSolution();
            Iterator iterator = querySolution.varNames();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                stringMatrix.setColumnName(++n2, string);
                RDFNode rDFNode = querySolution.get(string);
                if (rDFNode == null) continue;
                String string2 = rDFNode.toString();
                if (rDFNode.isResource()) {
                    Resource resource = (Resource)rDFNode;
                    String[] stringArray = RJenaHelper.split(prefixMapping, resource);
                    if (stringArray[0] == null) {
                        if (resource.getURI() != null) {
                            stringMatrix.set(n, n2, resource.getURI());
                            continue;
                        }
                        stringMatrix.set(n, n2, "" + resource.hashCode());
                        continue;
                    }
                    stringMatrix.set(n, n2, stringArray[0] + ":" + stringArray[1]);
                    continue;
                }
                if (string2.endsWith("@en")) {
                    string2 = string2.substring(0, string2.lastIndexOf(64));
                }
                stringMatrix.set(n, n2, string2);
            }
        }
        return stringMatrix;
    }

    public static String[] split(PrefixMapping prefixMapping, Resource resource) {
        String string = resource.getURI();
        if (string == null) {
            return new String[]{null, null};
        }
        Map map = prefixMapping.getNsPrefixMap();
        Set set = map.keySet();
        String[] stringArray = new String[]{null, null};
        for (String string2 : set) {
            String string3 = (String)map.get(string2);
            if (!string.startsWith(string3)) continue;
            stringArray[0] = string2;
            stringArray[1] = string.substring(string3.length());
            return stringArray;
        }
        stringArray[1] = string;
        return stringArray;
    }
}

