/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.sse.writers;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Prologue;
import com.hp.hpl.jena.sparql.core.TriplePath;
import com.hp.hpl.jena.sparql.path.P_Alt;
import com.hp.hpl.jena.sparql.path.P_FixedLength;
import com.hp.hpl.jena.sparql.path.P_Inverse;
import com.hp.hpl.jena.sparql.path.P_Link;
import com.hp.hpl.jena.sparql.path.P_Mod;
import com.hp.hpl.jena.sparql.path.P_NegPropSet;
import com.hp.hpl.jena.sparql.path.P_OneOrMore;
import com.hp.hpl.jena.sparql.path.P_Path0;
import com.hp.hpl.jena.sparql.path.P_Path2;
import com.hp.hpl.jena.sparql.path.P_ReverseLink;
import com.hp.hpl.jena.sparql.path.P_Seq;
import com.hp.hpl.jena.sparql.path.P_ZeroOrMore;
import com.hp.hpl.jena.sparql.path.P_ZeroOrOne;
import com.hp.hpl.jena.sparql.path.Path;
import com.hp.hpl.jena.sparql.path.PathVisitor;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.sse.writers.WriterLib;
import com.hp.hpl.jena.sparql.sse.writers.WriterNode;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import org.openjena.atlas.io.IndentedLineBuffer;
import org.openjena.atlas.io.IndentedWriter;

public class WriterPath {
    private static final int NL = 1;
    private static final int NoNL = -1;
    private static final int NoSP = -2;
    private static final boolean multiline = false;
    private static final boolean maxBracket = false;

    public static void write(Path path, Prologue prologue) {
        WriterPath.output(IndentedWriter.stdout, path, new SerializationContext(prologue));
    }

    public static void output(IndentedWriter out, Path path, SerializationContext naming) {
        WriterPathVisitor w = new WriterPathVisitor(out, naming.getPrologue());
        w.output(path);
        w.out.flush();
    }

    public static void output(IndentedWriter out, TriplePath tp, SerializationContext naming) {
        WriterLib.start(out, "path", -1);
        WriterPath.outputPlain(out, tp, naming);
        WriterLib.finish(out, "path");
    }

    public static void outputPlain(IndentedWriter out, TriplePath tp, SerializationContext naming) {
        boolean oneLiner = WriterPath.oneLiner(tp.getPath());
        if (oneLiner) {
            WriterNode.output(out, tp.getSubject(), naming);
            out.print(" ");
            WriterPath.output(out, tp.getPath(), naming);
            out.print(" ");
            WriterNode.output(out, tp.getObject(), naming);
        } else {
            WriterPath.nl(out, false);
            WriterNode.output(out, tp.getSubject(), naming);
            WriterPath.nl(out);
            WriterPath.output(out, tp.getPath(), naming);
            WriterPath.nl(out);
            WriterNode.output(out, tp.getObject(), naming);
        }
    }

    private static boolean oneLiner(Path path) {
        return path instanceof P_Link;
    }

    private static void nl(IndentedWriter out) {
        WriterPath.nl(out, true);
    }

    private static void nl(IndentedWriter out, boolean spaceForNL) {
        if (spaceForNL) {
            out.print(" ");
        }
    }

    public static String asString(Path path) {
        return WriterPath.asString(path, null);
    }

    public static String asString(Path path, Prologue prologue) {
        IndentedLineBuffer buff = new IndentedLineBuffer();
        WriterPathVisitor w = new WriterPathVisitor(buff, prologue);
        path.visit(w);
        w.out.flush();
        return buff.asString();
    }

    private static class WriterPathVisitor
    implements PathVisitor {
        private IndentedWriter out;
        private Prologue prologue;

        WriterPathVisitor(IndentedWriter indentedWriter, Prologue prologue) {
            this.out = indentedWriter;
            this.prologue = prologue;
        }

        private void output(Path path) {
            path.visit(this);
        }

        private void output(Node node) {
            this.out.print(FmtUtils.stringForNode(node, this.prologue));
        }

        public void visit(P_Link pathNode) {
            this.output(pathNode.getNode());
        }

        public void visit(P_ReverseLink pathNode) {
            this.out.print("(");
            this.out.print("rev");
            this.out.print(" ");
            this.output(pathNode.getNode());
            this.out.print(")");
        }

        public void visit(P_NegPropSet pathNotOneOf) {
            this.out.print("(");
            this.out.print("notoneof");
            for (P_Path0 p : pathNotOneOf.getNodes()) {
                this.out.print(" ");
                this.output(p);
            }
            this.out.print(")");
        }

        public void visit(P_Alt pathAlt) {
            this.visit2(pathAlt, "alt");
        }

        public void visit(P_Seq pathSeq) {
            this.visit2(pathSeq, "seq");
        }

        private void visit2(P_Path2 path2, String nodeName) {
            this.out.print("(");
            this.out.print(nodeName);
            WriterPath.nl(this.out);
            this.out.incIndent();
            this.output(path2.getLeft());
            WriterPath.nl(this.out);
            this.output(path2.getRight());
            this.out.decIndent();
            this.out.print(")");
        }

        public void visit(P_Mod pathMod) {
            this.out.print("(");
            this.out.print("mod");
            this.out.print(" ");
            this.out.print(WriterPathVisitor.modInt(pathMod.getMin()));
            this.out.print(" ");
            this.out.print(WriterPathVisitor.modInt(pathMod.getMax()));
            this.writeOneLiner(pathMod.getSubPath());
            this.out.print(")");
        }

        private static String modInt(long value) {
            if (value == -2L) {
                return "*";
            }
            if (value == -1L) {
                return "_";
            }
            return Long.toString(value);
        }

        public void visit(P_FixedLength path) {
            this.out.print("(");
            this.out.print("pathN");
            this.out.print(" ");
            this.out.print(WriterPathVisitor.modInt(path.getCount()));
            this.writeOneLiner(path.getSubPath());
            this.out.print(")");
        }

        public void visit(P_ZeroOrOne path) {
            this.writeStarPlusQuery("path?", path.getSubPath());
        }

        public void visit(P_ZeroOrMore path) {
            this.writeStarPlusQuery("path*", path.getSubPath());
        }

        public void visit(P_OneOrMore path) {
            this.writeStarPlusQuery("path+", path.getSubPath());
        }

        private void writeOneLiner(Path path) {
            if (WriterPath.oneLiner(path)) {
                this.out.print(" ");
            } else {
                WriterPath.nl(this.out);
            }
            this.out.incIndent();
            this.output(path);
            this.out.decIndent();
        }

        private void writeStarPlusQuery(String tag, Path subPath) {
            this.out.print("(");
            this.out.print(tag);
            this.out.print(" ");
            this.writeOneLiner(subPath);
            this.out.print(")");
        }

        public void visit(P_Inverse reversePath) {
            this.out.print("(");
            this.out.print("reverse");
            WriterPath.nl(this.out);
            this.out.incIndent();
            Path p = reversePath.getSubPath();
            this.output(p);
            this.out.decIndent();
            WriterPath.nl(this.out, false);
            this.out.print(")");
        }
    }
}

