/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.iri.impl;

import com.hp.hpl.jena.iri.ViolationCodes;
import com.hp.hpl.jena.iri.impl.ComponentPatternParser;
import com.hp.hpl.jena.iri.impl.GroupAction;
import com.hp.hpl.jena.iri.impl.Parser;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ComponentPattern
implements ViolationCodes {
    final Pattern pattern;
    final GroupAction[] actions;
    static final List<Pattern> allPatterns = new ArrayList<Pattern>();

    ComponentPattern(String p) {
        ComponentPatternParser parser = new ComponentPatternParser(p);
        this.pattern = parser.get();
        this.actions = parser.actions();
        allPatterns.add(this.pattern);
    }

    public void analyse(Parser parser, int range) {
        Matcher m = this.pattern.matcher(parser.get(range));
        if (!m.matches()) {
            parser.recordError(range, 61);
            return;
        }
        for (int g = 1; g <= m.groupCount(); ++g) {
            if (m.start(g) == -1) continue;
            this.actions[g].check(m, parser, range);
        }
    }
}

