% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srrr.R
\name{srrr}
\alias{srrr}
\title{Row-sparse reduced-eank regresssion}
\usage{
srrr(Y, X, nrank = 2, method = c("glasso", "adglasso"),
     ic.type = c("BIC", "BICP", "AIC", "GCV", "GIC"),
     A0 = NULL, V0 = NULL, modstr = list(),
     control = list(), screening = FALSE)
}
\arguments{
\item{Y}{response matrix}

\item{X}{covariate matrix}

\item{nrank}{prespecified rank}

\item{method}{group lasso or adaptive group lasso}

\item{ic.type}{information criterion}

\item{A0}{initial value}

\item{V0}{initial value}

\item{modstr}{a list of model parameters controlling the model fitting}

\item{control}{a list of parameters for controlling the fitting process}

\item{screening}{If TRUE, marginal screening via glm is performed before
srrr fitting.}
}
\value{
A list of fitting results
}
\description{
Row-sparse reduced-rank regresssion for a prespecified rank; produce a
solution path for selecting predictors
}
\details{
Model parameters controlling the model fitting can be specified through
argument \code{modstr}. The available elements include
\itemize{
    \item{lamA}: tuning parameter sequence.
    \item{nlam}: number of tuning parameters; no effect if \code{lamA} is
        specified.
    \item{minLambda}: minimum lambda value, no effect if \code{lamA} is
        specified.
    \item{maxLambda}: maxmum lambda value, no effect if lamA is specified.
    \item{WA}: adaptive weights. If NULL, the weights are constructed from
        RRR.
    \item{wgamma}: power parameter for constructing adaptive weights.
}
Similarly, the computational parameters controlling optimization can be
specified through argument \code{control}. The available elements include
\itemize{
    \item{epsilon}: epsilonergence tolerance.
    \item{maxit}: maximum number of iterations.
    \item{inner.eps}: used in inner loop.
    \item{inner.maxit}: used in inner loop.
}
}
\examples{
library(rrpack)
p <- 100; n <- 100; nrank <- 3
mydata <- rrr.sim2(n, p, p0 = 10,q = 50, q0 = 10, nrank = 3,
                   s2n = 1, sigma = NULL, rho_X = 0.5, rho_E = 0)
fit1 <- with(mydata, srrr(Y, X, nrank = 3))
summary(fit1)
coef(fit1)
plot(fit1)
}
\references{
Chen, L. and Huang, J. Z. (2012) Sparse reduced-rank regression for
simultaneous dimension reduction and variable selection. \emph{Journal of
the American Statistical Association}. 107:500, 1533--1545.
}
