% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initial_split.R
\name{initial_split}
\alias{initial_split}
\alias{initial_time_split}
\alias{training}
\alias{testing}
\title{Simple Training/Test Set Splitting}
\usage{
initial_split(data, prop = 3/4, strata = NULL, breaks = 4, pool = 0.1, ...)

initial_time_split(data, prop = 3/4, lag = 0, ...)

training(x)

testing(x)
}
\arguments{
\item{data}{A data frame.}

\item{prop}{The proportion of data to be retained for modeling/analysis.}

\item{strata}{A variable in \code{data} (single character or name) used to conduct
stratified sampling. When not \code{NULL}, each resample is created within the
stratification variable. Numeric \code{strata} are binned into quartiles.}

\item{breaks}{A single number giving the number of bins desired to stratify a
numeric stratification variable.}

\item{pool}{A proportion of data used to determine if a particular group is
too small and should be pooled into another group. We do not recommend
decreasing this argument below its default of 0.1 because of the dangers
of stratifying groups that are too small.}

\item{...}{Not currently used.}

\item{lag}{A value to include a lag between the assessment
and analysis set. This is useful if lagged predictors will be used
during training and testing.}

\item{x}{An \code{rsplit} object produced by \code{initial_split()} or
\code{initial_time_split()}.}
}
\value{
An \code{rsplit} object that can be used with the \code{training} and \code{testing}
functions to extract the data in each split.
}
\description{
\code{initial_split} creates a single binary split of the data into a training
set and testing set. \code{initial_time_split} does the same, but takes the
\emph{first} \code{prop} samples for training, instead of a random selection.
\code{training} and \code{testing} are used to extract the resulting data.
}
\details{
With a \code{strata} argument, the random sampling is conducted
\emph{within the stratification variable}. This can help ensure that the
resamples have equivalent proportions as the original data set. For
a categorical variable, sampling is conducted separately within each class.
For a numeric stratification variable, \code{strata} is binned into quartiles,
which are then used to stratify. Strata below 10\% of the total are
pooled together; see \code{\link[=make_strata]{make_strata()}} for more details.
}
\examples{
set.seed(1353)
car_split <- initial_split(mtcars)
train_data <- training(car_split)
test_data <- testing(car_split)

data(drinks, package = "modeldata")
drinks_split <- initial_time_split(drinks)
train_data <- training(drinks_split)
test_data <- testing(drinks_split)
c(max(train_data$date), min(test_data$date)) # no lag

# With 12 period lag
drinks_lag_split <- initial_time_split(drinks, lag = 12)
train_data <- training(drinks_lag_split)
test_data <- testing(drinks_lag_split)
c(max(train_data$date), min(test_data$date)) # 12 period lag
}
