% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsat_preview.R
\name{rsat_preview}
\alias{rsat_preview}
\alias{rsat_preview,rtoi,Date-method}
\alias{rsat_preview,rtoi,date}
\alias{rsat_preview,rtoi,missing-method}
\alias{rsat_preview,rtoi,missing}
\alias{rsat_preview,records,Date-method}
\alias{rsat_preview,records,date}
\alias{rsat_preview,records,numeric-method}
\alias{rsat_preview,rtoi,numeric}
\title{Preview a \code{records} or an \code{rtoi} object}
\usage{
rsat_preview(x, n, ...)

\S4method{rsat_preview}{rtoi,Date}(x, n, lpos = c(3, 2, 1), add.layer = FALSE, verbose = FALSE, ...)

\S4method{rsat_preview}{rtoi,missing}(x, n, lpos = c(3, 2, 1), add.layer = FALSE, verbose = FALSE, ...)

\S4method{rsat_preview}{records,Date}(
  x,
  n,
  lpos = c(3, 2, 1),
  tmp_dir = file.path(tempdir()),
  add.layer = FALSE,
  verbose = FALSE,
  get.map = TRUE,
  ...
)

\S4method{rsat_preview}{records,numeric}(
  x,
  n,
  lpos = c(3, 2, 1),
  tmp_dir = file.path(tempdir()),
  add.layer = FALSE,
  verbose = FALSE,
  get.map = TRUE,
  ...
)
}
\arguments{
\item{x}{a \code{records} or an \code{rtoi} object.}

\item{n}{the date expressed as the temporal index in the time series.}

\item{...}{additional arguments}

\item{lpos}{vector argument. Defines the position of the red-green-blue
layers to enable a false color visualization.}

\item{add.layer}{logical argument. If \code{TRUE}, the function plots the
image on an existing map.}

\item{verbose}{logical argument. If \code{TRUE}, the function prints the
running steps and warnings.}

\item{tmp_dir}{character argument. The directory where preview images
are located.}

\item{get.map}{logical argument. If \code{TRUE}, the function
return the leaflet map.}
}
\value{
nothing. Previews the region in the viewer.
}
\description{
Preview a \code{records} or an \code{rtoi} object
}
\examples{
\dontrun{
library(rsat)

# load example rtoi
file.copy(from=system.file("ex/Navarre",package="rsat"),
         to=tempdir(),
         recursive = TRUE)

navarre <- read_rtoi(file.path(tempdir(),"Navarre"))

set_credentials("username", "password")
set_database(file.path(tempdir(), "DATABASE"))

# by default the first date in rtoi is previewed
rsat_preview(navarre)


preview.dates <- dates(navarre)
# use add.layer to preview images of several days
rsat_preview(navarre,preview.dates[2],add.layer = TRUE)

# you can also preview records
rcrds <- records(navarre)
rsat_preview(rcrds, n = 1)
}
}
