% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsconnect-package.R
\docType{package}
\name{rsconnect-package}
\alias{rsconnect-package}
\alias{rsconnect}
\title{Deployment Interface for R Markdown Documents and Shiny Applications}
\description{
The `rsconnect`` package provides a programmatic deployment
interface for RPubs, shinyapps.io, and RStudio Connect. Supported contents
types include R Markdown documents, Shiny applications, plots, and static
web content.
}
\section{Managing Applications}{


Deploy and manage applications with the following functions:
\itemize{
\item \code{\link[=deployApp]{deployApp()}}:
Deploy a Shiny application to a server.
\item \code{\link[=configureApp]{configureApp()}}:
Configure an application currently running on a server.
\item \code{\link[=restartApp]{restartApp()}}:
Restart an application currently running on a server.
\item \code{\link[=terminateApp]{terminateApp()}}:
Terminate an application currently running on a server.
\item \code{\link[=deployments]{deployments()}}:
List deployment records for a given application directory.
}

More information on application management is available in the
\code{\link[=applications]{applications()}} help page.
}

\section{Managing Accounts and Users}{


Manage accounts on the local system.
\itemize{
\item \code{\link[=setAccountInfo]{setAccountInfo()}}:
Register an account.
\item \code{\link[=removeAccount]{removeAccount()}}:
Remove an account.
\item \code{\link[=accountInfo]{accountInfo()}}:
View information for a given account.
}

More information on account management is available in the
\code{\link[=accounts]{accounts()}} help page.
}

\keyword{package}
