% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coords.R
\name{coords}
\alias{coords}
\title{Extract Coordinates}
\usage{
coords(x)
}
\arguments{
\item{x}{an object of class \code{rsgeo}}
}
\value{
A \code{data.frame} with columns \code{x}, \code{y}. Additional columns are returned based
on the geometry type. Additional columns are:
\itemize{
\item \code{id}
\item \code{line_id}: refers to the \code{LineString} ID for \code{rs_LINESTRING}, or the component \code{LineString} in a \code{MultiLineString}, or as the ring ID for a \code{Polygon}.
\item \code{multilinestring_id}
\item \code{polygon_id}
\item \code{multipolygon_id}
}
}
\description{
Given an \code{rsgeo} class object, extract the object's coordinates as a data frame.
Empty or missing geometries are ignored.
}
\examples{
pnt <- geom_point(3, 0.14)
mpnt <- geom_multipoint(1:10, 10:1)
ln <- geom_linestring(1:10, 10:1)
ply <- geom_polygon(c(0, 1, 1, 0, 0), c(0, 0, 1, 1, 0))

coords(pnt)
coords(mpnt)
coords(ln)
coords(union_geoms(rep(ln, 2)))
coords(ply)
coords(union_geoms(rep(ply, 2)))
}
