% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stack_rasters.R
\name{stack_rasters}
\alias{stack_rasters}
\title{Create and save a multi-band output raster by combining input rasters}
\usage{
stack_rasters(
  rasters,
  output_filename,
  ...,
  resolution,
  extent,
  reference_raster = 1,
  resampling_method = "bilinear",
  band_names,
  gdalwarp_options = c("-multi", "-overwrite", "-co", "COMPRESS=DEFLATE", "-co",
    "PREDICTOR=2", "-co", "NUM_THREADS=ALL_CPUS"),
  gdal_config_options = c(VSI_CACHE = "TRUE", GDAL_CACHEMAX = "30\%", VSI_CACHE_SIZE =
    "10000000", GDAL_HTTP_MULTIPLEX = "YES", GDAL_INGESTED_BYTES_AT_OPEN = "32000",
    GDAL_DISABLE_READDIR_ON_OPEN = "EMPTY_DIR", GDAL_HTTP_VERSION = "2",
    GDAL_HTTP_MERGE_CONSECUTIVE_RANGES = "YES", GDAL_NUM_THREADS = "ALL_CPUS")
)
}
\arguments{
\item{rasters}{A list of rasters to combine into a single multi-band raster,
either as SpatRaster objects from \code{\link[terra:rast]{terra::rast()}} or character file paths
to files that can be read by \code{\link[terra:rast]{terra::rast()}}. Rasters will be "stacked" upon
one another, preserving values. They must share CRS.}

\item{output_filename}{The location to save the final "stacked" raster. If
this filename has a "vrt" extension as determined by \code{tools::file_ext()},
then this function exits after creating a VRT; otherwise, this function will
create a VRT and then use \code{sf::gdal_utils("warp")} to convert the VRT into
another format.}

\item{...}{These dots are for future extensions and must be empty.}

\item{resolution}{Numeric of length 2, representing the target X and Y
resolution of the output raster. If only a single value is provided, it will
be used for both X and Y resolution; if more than 2 values are provided, an
error is thrown.}

\item{extent}{Numeric of length 4, representing the target xmin, ymin, xmax,
and ymax values of the output raster (its bounding box), in that order.}

\item{reference_raster}{The position (index) of the raster in \code{rasters} to
take extent, resolution, and CRS information from. No reprojection is done.
If \code{resolution} or \code{extent} are provided, they override the values from the
reference raster.}

\item{resampling_method}{The method to use when resampling to different
resolutions in the VRT.}

\item{band_names}{Either a character vector of band names, or a function that
when given a character vector of band names, returns a character vector of
the same length containing new band names.}

\item{gdalwarp_options}{Options passed to \code{gdalwarp} through the \code{options}
argument of \code{\link[sf:gdal_utils]{sf::gdal_utils()}}. This argument is ignored (with a warning)
if \code{output_filename} is a VRT.}

\item{gdal_config_options}{Options passed to \code{gdalwarp} through the
\code{config_options} argument of \code{\link[sf:gdal_utils]{sf::gdal_utils()}}.  This argument is ignored
(with a warning) if \code{output_filename} is a VRT.}
}
\value{
\code{output_filename}, unchanged.
}
\description{
This function creates an output raster that "stacks" all the bands of its
input rasters, as though they were loaded one after another into a GIS. It
does this by first constructing a GDAL virtual raster, or "VRT", and then
optionally uses GDAL's warper to convert this VRT into a standalone file.
The VRT is fast to create and does not require much space, but does require
the input rasters not be moved or altered. Creating a standalone raster from
this file may take a long time and a large amount of disk space.
}
\examples{
stack_rasters(
  list(
    system.file("rasters/dpdd.tif", package = "rsi"),
    system.file("rasters/example_sentinel1.tif", package = "rsi")
  ),
  tempfile(fileext = ".vrt")
)

}
