% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events.R
\name{hypnogram}
\alias{hypnogram}
\title{Filter and reorder an events dataframe to keep only sleep stages related-events.}
\usage{
hypnogram(events, labels = c("N3", "N2", "N1", "REM", "AWA"))
}
\arguments{
\item{events}{Events dataframe. Dataframe must have \code{begin} (\code{POSIXt}), \code{end} (\code{POSIXt}) and \code{event}}

\item{labels}{Sleep stages labels. Defaults to \code{c("N3","N2","N1","REM","AWA")}.}
}
\value{
hypnogram dataframe.
}
\description{
Remove non-sleep stages events and reorder dataframe rows using the \code{begin} column.
}
\examples{
e <- data.frame(begin = as.POSIXlt(c(1536967800,1536967860,1536967830),origin = "1970-01-01"))
e$end <- as.POSIXlt(c(1536967830,1536967890,1536967860), origin = "1970-01-01")
e$event = c("back-position","N3","REM")
hypnogram(e)
}
